package com.viontech.keliu.controller;

import com.viontech.keliu.service.ClearService;
import com.viontech.keliu.util.DateUtil;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.Date;

@RestController
@RequestMapping("/pictures")
public class HistoryClearController {

    @Resource
    private ClearService clearService;

    @DeleteMapping("")
    public Object clearHistoryPic(@RequestParam(required = false) Date startDate,@RequestParam(required = false) Date endDate, @RequestParam(required = false) Date countDate){
        if(countDate != null){
            startDate = countDate;
            endDate = countDate;
        }

        Date currentDate=startDate;
        do{
            try {
                clearService.delete(currentDate);
                currentDate= DateUtil.addDays(currentDate,1);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }while(!currentDate.after(endDate));
        return null;
    }


}
