/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.quratz;

import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.User;
import com.viontech.keliu.model.UserMall;
import com.viontech.keliu.model.UserMallAlarmMessage;
import com.viontech.keliu.service.adapter.WeiXinService;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.wechat.model.Data;
import com.viontech.keliu.wechat.model.DataItem;
import com.viontech.keliu.wechat.model.TemplateMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CountDataAlarmQuratzJob {
    private static Logger logger = LoggerFactory.getLogger(CountDataAlarmQuratzJob.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SELECT_MALL = "select id,name from b_mall where status=1";
    private final String SQL_SELECT_USERMALL = "select * from r_user_mall";
    private final String SQL_SELECT_USER = "select id,open_id,login_name from s_user where open_id is not null";
    private final String SQL_SELECT_MALL_MINUTE_COUNT_DATA = "select DISTINCT mall_id from d_mall_minute_count_data where counttime > ? and countdate = ?";
    @Autowired
    private WeiXinService weiXinService;

    @Scheduled(cron="0 0 11-21 * * ?")
    public void execute() {
        logger.info(">>>>>>>> \u5f00\u59cb\u6267\u884c\u5546\u573a\u7ea7\u5ba2\u6d41\u6570\u636e\u68c0\u6d4b {}", (Object)DateUtil.format((String)DateUtil.FORMAT_LONG, (Date)new Date()));
        List userMalls = this.jdbcTemplate.query("select * from r_user_mall", (RowMapper)new BeanPropertyRowMapper(UserMall.class));
        List malls = this.jdbcTemplate.query("select id,name from b_mall where status=1", (RowMapper)new BeanPropertyRowMapper(Mall.class));
        Map<Long, String> mallNameMap = malls.stream().collect(Collectors.toMap(Mall::getId, Mall::getName));
        List users = this.jdbcTemplate.query("select id,open_id,login_name from s_user where open_id is not null", (RowMapper)new BeanPropertyRowMapper(User.class));
        logger.warn("\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\u53f7\u7684\u7528\u6237\u6709{}\u4e2a", (Object)users.size());
        Map<Long, String> userOpenIdMap = users.stream().collect(Collectors.toMap(User::getId, User::getOpenId));
        Map<Long, String> userNameMap = users.stream().collect(Collectors.toMap(User::getId, User::getLoginName));
        HashMap<Long, List> mallUserMap = new HashMap<Long, List>();
        for (UserMall userMall : userMalls) {
            if (mallNameMap.get(userMall.getMallId()) == null) {
                logger.info("\u5546\u573a {} \u72b6\u6001\u4e3a\u505c\u4e1a\u72b6\u6001 \u8df3\u8fc7", (Object)userMall.getMallId());
                continue;
            }
            ArrayList<Long> userIds2 = (ArrayList<Long>)mallUserMap.get(userMall.getMallId());
            if (userIds2 == null) {
                userIds2 = new ArrayList<Long>();
                mallUserMap.put(userMall.getMallId(), userIds2);
            }
            if (userOpenIdMap.get(userMall.getUserId()) == null) continue;
            userIds2.add(userMall.getUserId());
        }
        Date checkTime = DateUtil.addHours((Date)new Date(), (int)-1);
        List mallIds = this.jdbcTemplate.queryForList("select DISTINCT mall_id from d_mall_minute_count_data where counttime > ? and countdate = ?", Long.class, new Object[]{checkTime, checkTime});
        logger.warn("\u4e00\u5c0f\u65f6\u5185\u6709\u6570\u636e\u7684\u5546\u573a\u6570\u91cf\u4e3a{}", (Object)mallIds.size());
        HashMap<Long, UserMallAlarmMessage> alarmMeesageMap = new HashMap<Long, UserMallAlarmMessage>();
        mallUserMap.forEach((mallId, userIds) -> {
            if (mallIds.contains(mallId)) {
                return;
            }
            String mallName = (String)mallNameMap.get(mallId);
            if (mallName == null) {
                logger.warn("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u6ca1\u6709\u5546\u573a\u540d\u79f0", mallId);
                return;
            }
            logger.warn("\u5546\u573a {} \u5b58\u5728\u5f02\u5e38\u6570\u636e", (Object)mallName);
            userIds.forEach(userId -> {
                UserMallAlarmMessage userMallAlarmMessage = (UserMallAlarmMessage)alarmMeesageMap.get(userId);
                if (userMallAlarmMessage == null) {
                    userMallAlarmMessage = new UserMallAlarmMessage();
                    userMallAlarmMessage.setDate(DateUtil.format((String)DateUtil.FORMAT_LONG, (Date)new Date()));
                    userMallAlarmMessage.setTitle("\u95e8\u5e97\u5ba2\u6d41\u6570\u636e\u5f02\u5e38\u68c0\u6d4b\u62a5\u8b66");
                    userMallAlarmMessage.setName("\u95e8\u5e97\u6570\u636e");
                    userMallAlarmMessage.setType("\u6570\u636e\u65ad\u5f00");
                    alarmMeesageMap.put((Long)userId, userMallAlarmMessage);
                }
                if (userMallAlarmMessage.getRemark() == null) {
                    userMallAlarmMessage.setRemark(mallName);
                } else {
                    userMallAlarmMessage.setRemark(userMallAlarmMessage.getRemark() + "," + mallName);
                }
            });
        });
        String accessToken = this.weiXinService.getAccessToken();
        alarmMeesageMap.forEach((userId, userMallAlarmMessage) -> {
            TemplateMessage templateMessage = new TemplateMessage();
            templateMessage.setTouser((String)userOpenIdMap.get(userId));
            templateMessage.setTemplate_id("V-MT-R2kNxXWQOeWZvuAW87rPoXuMxZ0QcjpfBSv_n8");
            Data data = new Data();
            data.setFirst(new DataItem(userMallAlarmMessage.getTitle()));
            data.setKeyword1(new DataItem(userMallAlarmMessage.getName()));
            data.setKeyword2(new DataItem(userMallAlarmMessage.getDate()));
            data.setKeyword3(new DataItem(userMallAlarmMessage.getType()));
            data.setRemark(new DataItem(userMallAlarmMessage.getRemark()));
            templateMessage.setData(data);
            this.weiXinService.sendTemplateMessage(templateMessage, accessToken);
            logger.warn(userMallAlarmMessage.getDate() + "\t\u7ed9\u7528\u6237:" + (String)userNameMap.get(userId) + "\t\u53d1\u9001\u6d88\u606f:" + userMallAlarmMessage.getRemark());
        });
        logger.info(">>>>>>>> \u5b8c\u6210\u6267\u884c\u5546\u573a\u7ea7\u5ba2\u6d41\u6570\u636e\u68c0\u6d4b {}", (Object)DateUtil.format((String)DateUtil.FORMAT_LONG, (Date)new Date()));
    }
}

