/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller;

import com.viontech.keliu.fo.LoginFo;
import com.viontech.keliu.service.adapter.WeiXinService;
import com.viontech.keliu.util.HttpRequestUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    @Autowired
    private WeiXinService weiXinService;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Value(value="${auth.url}")
    private String authUrl;

    @PostMapping(value={"/login"})
    public Object login(@RequestBody LoginFo login) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String loginUrl = this.authUrl + "/users/login";
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("username", login.getUsername());
            params.put("password", login.getPassword());
            JSONObject jsonParams = JSONObject.fromObject(params);
            JSONObject result = HttpRequestUtil.doPost((String)loginUrl, (JSONObject)jsonParams);
            if (result == null) {
                response.put("code", 500);
                response.put("success", false);
                response.put("message", "\u9274\u6743\u5931\u8d25");
                return response;
            }
            if (login.getCode() == null) {
                response.put("code", 500);
                response.put("success", false);
                response.put("message", "\u9274\u6743\u5931\u8d25");
                return response;
            }
            String openId = this.weiXinService.getOpenIdByCode(login.getCode());
            if (openId == null) {
                response.put("code", 500);
                response.put("success", true);
                response.put("message", "\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                return response;
            }
            String sql = "update s_user set open_id = ? where login_name = ?";
            this.jdbcTemplate.update(sql, new Object[]{openId, login.getUsername()});
            response.put("code", 200);
            response.put("success", true);
            response.put("message", "\u7ed1\u5b9a\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.put("code", 500);
            response.put("success", false);
            response.put("message", "\u7ed1\u5b9a\u5931\u8d25");
            return response;
        }
    }
}

