package com.viontech.keliu.util;

import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpRequestUtil {
	/**
	 * 获得动态全局唯一票据（注意：此值每天获取有次数有限，每次有效时间为两小时，故在过期后再次请求即可）
	 * 
	 * @return
	 */
	public static String getAccess(String accessUrl) {
		return String.valueOf(HttpRequestUtil.json2map(
				HttpRequestUtil.sendByGet(accessUrl)).get("access_token"));
	}

	/**
	 * 获得用户基本信息
	 * 
	 * @param accessToken
	 * @param openId
	 * @return
	 */
	public static Map<String, Object> getUserInfo(String userInfoUrl,String accessToken,String openId) {
		return json2map(sendByGet(userInfoUrl));
	}

	/***
	 * 获得以关注的所有用户openid集合
	 * 
	 * @param accessToken
	 * @return
	 */
	public static Map<String, Object> getAllUserInfo(String allUserInfoUrl,String accessToken) {
		return json2map(sendByGet(allUserInfoUrl));
	}

	/***
	 * get接口请求
	 * 
	 * @param url
	 * @return
	 */
	public static String sendByGet(String url) {
		HttpClient httpClient = new DefaultHttpClient();
		HttpGet httpgets = null;
		String result = "";
		try {
			httpgets = new HttpGet(url);
			HttpResponse response = httpClient.execute(httpgets);
			HttpEntity entity = response.getEntity();
			if (entity != null) {
				InputStream instreams = entity.getContent();
				result = convertStreamToString(instreams);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			httpgets.abort();
		}
		return result;
	}


	public static Object sendByPost(String sendUrl, String message) {
		String result = null;
		PrintWriter out = null;
		BufferedReader in = null;
		try {
			URL realUrl = new URL(sendUrl);
			// 打开和URL之间的连接
			URLConnection conn = realUrl.openConnection();
			// 设置通用的请求属性
			conn.setRequestProperty("accept", "*/*");
			conn.setRequestProperty("connection", "Keep-Alive");
			conn.setRequestProperty("user-agent",
					"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			conn.setRequestProperty("Charset", "UTF-8");
			// 发送POST请求必须设置如下两行
			conn.setDoOutput(true);
			conn.setDoInput(true);
			// 获取URLConnection对象对应的输出流
			out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), "utf-8"));
			// 发送请求参数
			out.print(message);
			// flush输出流的缓冲
			out.flush();
			// 定义BufferedReader输入流来读取URL的响应
			in = new BufferedReader(
					new InputStreamReader(conn.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				if(result == null) {
					result = "";
				}
				result += line;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
//		result ="{\"errcode\": 0,\"errmsg\": \"ok\",\"msgid\": 342315427378331650}";
		return result;
	}

	/***
	 * 对请求接口返回信息处理
	 * 
	 * @param is
	 * @return
	 */
	private static String convertStreamToString(InputStream is) {
		BufferedReader reader = new BufferedReader(new InputStreamReader(is));
		StringBuilder sb = new StringBuilder();
		String line = null;
		try {
			while ((line = reader.readLine()) != null) {
				sb.append(new String(line.getBytes(),"UTF-8") + "\n");
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return sb.toString();
	}

	/***
	 * json字符串转map
	 * 
	 * @param json
	 * @return
	 */
	public static Map<String, Object> json2map(String json) {
		JSONObject jsonObject = JSONObject.fromObject(json);
		Map<String, Object> data = new HashMap<String, Object>();
		Iterator it = jsonObject.keys();
		// 遍历jsonObject数据，添加到Map对象
		while (it.hasNext()) {
			String key = String.valueOf(it.next());
			Object value =  jsonObject.get(key);
			data.put(key, value);
		}
		return data;
	}

	public static JSONObject doPost(String url,JSONObject json){

		CloseableHttpClient httpclient = HttpClientBuilder.create().build();
		HttpPost post = new HttpPost(url);
		JSONObject response = null;
		try {
			StringEntity s = new StringEntity(json.toString(),"UTF-8");
			s.setContentEncoding("UTF-8");
			s.setContentType("application/json");//发送json数据需要设置contentType
			post.setEntity(s);
			HttpResponse res = httpclient.execute(post);
			if(res.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
				String result = EntityUtils.toString(res.getEntity());// 返回json格式：
				response = JSONObject.fromObject(result);
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return response;
	}
}
