package com.viontech.keliu.service.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.service.adapter.WeiXinService;
import com.viontech.keliu.util.HttpRequestUtil;
import com.viontech.keliu.wechat.model.TemplateMessage;
import net.sf.json.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import static com.viontech.keliu.util.HttpRequestUtil.getAccess;

@Service
public class WeiXinServiceImpl implements WeiXinService {
	private final Logger logger = LoggerFactory.getLogger(WeiXinServiceImpl.class);
	private final String appId = "wx96d05a0e5749f058";
	private final String secret = "6033fa4f99d855cb914ec1fe2ecc77bd";
	@Override
	public String getOpenIdByCode(String code) {
			Map<String,Object> parameters = new HashMap<String,Object>();
			parameters.put("appid", appId);
			parameters.put("secret", secret);
			parameters.put("code", code);
			parameters.put("grant_type", "authorization_code");
			StringBuffer urlSb = new StringBuffer();
			//读取输入流，即返回文本内容
			StringBuffer sb;
			try {
				urlSb.append("https://api.weixin.qq.com/sns/oauth2/access_token");
				if(parameters.size()>0){
					urlSb.append("?");
					for (Entry<String, Object> entry : parameters.entrySet()) {
						urlSb.append(entry.getKey()).append("=").append(entry.getValue().toString()).append("&");
					}
					urlSb.setLength(urlSb.length()-1);
				}
				
				HttpClient client = new DefaultHttpClient();
				HttpGet get = new HttpGet(urlSb.toString());
				HttpResponse result = client.execute(get);
				InputStream is = result.getEntity().getContent();
				sb = new StringBuffer();
				BufferedReader br = new BufferedReader(new InputStreamReader(is,"utf-8"));
				String line = "";
				while((line=br.readLine())!=null){
					sb.append(line);
				}
				ObjectMapper mapper = new ObjectMapper();
				mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
				HashMap resultMap = mapper.readValue(sb.toString(),HashMap.class);
				String openId = resultMap.get("openid").toString();
				logger.info("获取到的openId："+openId);
				return openId;
			} catch (ClientProtocolException e) {
				logger.error("",e);
				e.printStackTrace();
			} catch (UnsupportedOperationException e) {
				logger.error("",e);
				e.printStackTrace();
			} catch (UnsupportedEncodingException e) {
				logger.error("",e);
				e.printStackTrace();
			} catch (IOException e) {
				logger.error("",e);
				e.printStackTrace();
			}
			return null;
	}

	@Override
	public String sendTemplateMessage(TemplateMessage templateMessage,String accessToken) {
        JSONObject jsonParams=JSONObject.fromObject(templateMessage);
        HttpRequestUtil.doPost("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token="+accessToken,jsonParams);
		return null;
	}

	@Override
	public String getAccessToken() {
        String accessToken = getAccess("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appId + "&secret=" + secret);
        return accessToken;
	}

}
