package com.viontech.keliu.quratz;

import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.User;
import com.viontech.keliu.model.UserMall;
import com.viontech.keliu.model.UserMallAlarmMessage;
import com.viontech.keliu.service.adapter.WeiXinService;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.wechat.model.Data;
import com.viontech.keliu.wechat.model.DataItem;
import com.viontech.keliu.wechat.model.TemplateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * Created by 苏曼 on 2018/12/1.
 */
@Component
public class CountDataAlarmQuratzJob {

    private static Logger logger = LoggerFactory.getLogger(CountDataAlarmQuratzJob.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private final String SQL_SELECT_MALL = "select id,name from b_mall where status=1";

    private final String  SQL_SELECT_USERMALL = "select * from r_user_mall";

    private final String  SQL_SELECT_USER = "select id,open_id,login_name from s_user where open_id is not null";

    private final String SQL_SELECT_MALL_MINUTE_COUNT_DATA= "select DISTINCT mall_id from d_mall_minute_count_data where counttime > ? and countdate = ?";

    @Autowired
    private WeiXinService weiXinService;
    @Scheduled(cron = "0 0 11-21 * * ?")
    public void execute(){
        logger.info(">>>>>>>> 开始执行商场级客流数据检测 {}",DateUtil.format(DateUtil.FORMAT_LONG,new Date()));
        List<UserMall> userMalls = jdbcTemplate.query(SQL_SELECT_USERMALL, new BeanPropertyRowMapper<UserMall>(UserMall.class));
        List<Mall> malls = jdbcTemplate.query(SQL_SELECT_MALL , new BeanPropertyRowMapper<Mall>(Mall.class));
        Map<Long, String> mallNameMap = malls.stream().collect(Collectors.toMap(Mall::getId, Mall::getName));
        List<User> users = jdbcTemplate.query(SQL_SELECT_USER ,new BeanPropertyRowMapper<User>(User.class));
        logger.warn("已经绑定微信号的用户有{}个",users.size());
        Map<Long, String> userOpenIdMap = users.stream().collect(Collectors.toMap(User::getId, User::getOpenId));
        Map<Long,String> userNameMap = users.stream().collect(Collectors.toMap(User::getId,User::getLoginName));
        Map<Long,List<Long>> mallUserMap = new HashMap<>();
        for (UserMall userMall : userMalls) {
            if(mallNameMap.get(userMall.getMallId()) == null){
                logger.info("商场 {} 状态为停业状态 跳过",userMall.getMallId());
                continue;
            }
            List<Long> userIds = mallUserMap.get(userMall.getMallId());
            if(userIds == null){
                userIds = new ArrayList<>();
                mallUserMap.put(userMall.getMallId(),userIds);
            }
            if(userOpenIdMap.get(userMall.getUserId()) == null){
               // logger.info("用户 {} 暂未绑定微信号,跳过",userNameMap.get(userMall.getUserId()));
                continue;
            }
            userIds.add(userMall.getUserId());
        }

        Date checkTime = DateUtil.addHours(new Date(),-1);//前推一个小时
        //获取一个小时内有数据的商场或门店
        List<Long> mallIds = jdbcTemplate.queryForList(SQL_SELECT_MALL_MINUTE_COUNT_DATA, Long.class, checkTime, checkTime);
        logger.warn("一小时内有数据的商场数量为{}",mallIds.size());
        Map<Long,UserMallAlarmMessage> alarmMeesageMap = new HashMap<>();
        mallUserMap.forEach( (mallId,userIds) ->{
            if(mallIds.contains(mallId)){//如果这个商场有数据 跳过
                return;
            }
            String mallName = mallNameMap.get(mallId);
            if(mallName == null){
                logger.warn("商场id为{}的商场没有商场名称",mallId);
                return;
            }
            logger.warn("商场 {} 存在异常数据",mallName);
            userIds.forEach(userId ->{//商场出现问题 需要报警
                UserMallAlarmMessage userMallAlarmMessage = alarmMeesageMap.get(userId);
                if(userMallAlarmMessage == null){
                    userMallAlarmMessage = new UserMallAlarmMessage();
                    userMallAlarmMessage.setDate(DateUtil.format(DateUtil.FORMAT_LONG,new Date()));
                    userMallAlarmMessage.setTitle("门店客流数据异常检测报警");
                    userMallAlarmMessage.setName("门店数据");
                    userMallAlarmMessage.setType("数据断开");
                    alarmMeesageMap.put(userId,userMallAlarmMessage);
                }
                if(userMallAlarmMessage.getRemark() == null){
                    userMallAlarmMessage.setRemark(mallName);
                }else{
                    userMallAlarmMessage.setRemark(userMallAlarmMessage.getRemark()+","+mallName);
                }
            });
        });
        String accessToken  = weiXinService.getAccessToken();
        alarmMeesageMap.forEach((userId,userMallAlarmMessage)->{
            TemplateMessage templateMessage = new TemplateMessage();
            templateMessage.setTouser(userOpenIdMap.get(userId));
            templateMessage.setTemplate_id("V-MT-R2kNxXWQOeWZvuAW87rPoXuMxZ0QcjpfBSv_n8");
            Data data = new Data();
            data.setFirst(new DataItem(userMallAlarmMessage.getTitle()));
            data.setKeyword1(new DataItem(userMallAlarmMessage.getName()));
            data.setKeyword2(new DataItem(userMallAlarmMessage.getDate()));
            data.setKeyword3(new DataItem(userMallAlarmMessage.getType()));
            data.setRemark(new DataItem(userMallAlarmMessage.getRemark()));
            templateMessage.setData(data);
            weiXinService.sendTemplateMessage(templateMessage,accessToken);
            logger.warn(userMallAlarmMessage.getDate()+"\t给用户:"+userNameMap.get(userId)+"\t发送消息:"+userMallAlarmMessage.getRemark());
        });

        logger.info(">>>>>>>> 完成执行商场级客流数据检测 {}",DateUtil.format(DateUtil.FORMAT_LONG,new Date()));
    }


}
