package com.viontech.keliu.controller;

import com.viontech.keliu.fo.LoginFo;
import com.viontech.keliu.service.adapter.WeiXinService;
import com.viontech.keliu.util.HttpRequestUtil;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by 苏曼 on 2018/12/1.
 */
@RestController
public class UserController {
    @Autowired
    private WeiXinService weiXinService;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Value("${auth.url}")
    private String authUrl;//服务头url


    @PostMapping("/login")
    public Object login(@RequestBody LoginFo login){
        Map response = new HashMap();
        try {

            String loginUrl = authUrl+"/users/login";
            Map<String,Object> params = new LinkedHashMap<>();
            params.put("username",login.getUsername());
            params.put("password",login.getPassword());
            JSONObject jsonParams=JSONObject.fromObject(params);
            JSONObject result= HttpRequestUtil.doPost(loginUrl,jsonParams);
            if(result==null) {
                response.put("code",500);
                response.put("success",false);
                response.put("message","鉴权失败");
                return response;
            }

            if(login.getCode() == null ){
                response.put("code",500);
                response.put("success",false);
                response.put("message","鉴权失败");
                return response;
            }

            String openId = weiXinService.getOpenIdByCode(login.getCode());
            if(openId == null){
                response.put("code",500);
                response.put("success",true);
                response.put("message","获取微信用户信息失败");
                return response;
            }
            String sql ="update s_user set open_id = ? where login_name = ?";
            jdbcTemplate.update(sql,openId,login.getUsername());
            response.put("code",200);
            response.put("success",true);
            response.put("message","绑定成功");
            return response;
        } catch (Exception e) {
            e.printStackTrace();
        }
        response.put("code",500);
        response.put("success",false);
        response.put("message","绑定失败");
        return response;

    }

}
