package com.viontech.keliu.alarm;



import com.aliyuncs.exceptions.ClientException;
import com.viontech.keliu.sms.SendSms;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.List;
import java.util.Map;

/**
 * @description: 报警的抽象类
 * @author: WJY
 * @date: 2018-10-10 15:34
 */
public abstract class Alarm {


   @Autowired
   JdbcTemplate jdbcTemplate;

   @Autowired
   SendSms sendSms;

    @Value("${alarm.name}")
    String dataBaseId ;
    @Value("${alarm.phones}")
    String phones ;

    public  void check() throws ClientException {
        List<Integer> resultMap = jdbcTemplate.queryForList(getSql(),Integer.class);
        if(!isValid(resultMap)){
            sendSms.SmsAlarm(dataBaseId,phones);
        }
    }
    abstract Boolean isValid(List<Integer> list );//根据查询的结果进行有效性的判断

    abstract String getSql();

    int getSize(){
        String sql = "select id from b_mall where status=1";
        return  jdbcTemplate.queryForList(sql,Integer.class).size();
    }
}
