package com.viontech.keliu;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * Created by 苏曼 on 2018/10/15.
 */
@EnableAutoConfiguration
@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages = { "com.viontech.*"})
@EnableScheduling
public class Application {
    private static Logger logger = LoggerFactory.getLogger(Application.class);
    public static void main(String[] args) {
        try {
            SpringApplication.run(Application.class, args);
        } catch (Exception e) {
            logger.error("程序启动失败",e);
            e.printStackTrace();
        }
    }
}
