/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;

public class CommonMixedErrorHandler
implements CommonErrorHandler {
    private final CommonErrorHandler recordErrorHandler;
    private final CommonErrorHandler batchErrorHandler;

    public CommonMixedErrorHandler(CommonErrorHandler recordErrorHandler, CommonErrorHandler batchErrorHandler) {
        Assert.notNull((Object)recordErrorHandler, (String)"'recordErrorHandler' cannot be null");
        Assert.notNull((Object)batchErrorHandler, (String)"'batchErrorHandler' cannot be null");
        this.recordErrorHandler = recordErrorHandler;
        this.batchErrorHandler = batchErrorHandler;
    }

    @Override
    public boolean seeksAfterHandling() {
        return this.recordErrorHandler.seeksAfterHandling();
    }

    @Override
    public boolean deliveryAttemptHeader() {
        return this.recordErrorHandler.deliveryAttemptHeader();
    }

    @Override
    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        if (batchListener) {
            this.batchErrorHandler.handleOtherException(thrownException, consumer, container, batchListener);
        } else {
            this.recordErrorHandler.handleOtherException(thrownException, consumer, container, batchListener);
        }
    }

    @Override
    public boolean handleOne(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        return this.recordErrorHandler.handleOne(thrownException, record, consumer, container);
    }

    @Override
    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.recordErrorHandler.handleRemaining(thrownException, records, consumer, container);
    }

    @Override
    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.batchErrorHandler.handleBatch(thrownException, data, consumer, container, invokeListener);
    }

    @Override
    public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        return this.recordErrorHandler.deliveryAttempt(topicPartitionOffset);
    }

    @Override
    public void clearThreadState() {
        this.batchErrorHandler.clearThreadState();
        this.recordErrorHandler.clearThreadState();
    }

    @Override
    public boolean isAckAfterHandle() {
        return this.recordErrorHandler.isAckAfterHandle();
    }

    @Override
    public void setAckAfterHandle(boolean ack) {
        this.batchErrorHandler.setAckAfterHandle(ack);
        this.recordErrorHandler.setAckAfterHandle(ack);
    }
}

