/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.SpelExpressionConverterConfiguration;
import org.springframework.cloud.stream.reflection.GenericsUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultBinderFactory
implements BinderFactory,
DisposableBean,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, BinderConfiguration> binderConfigurations;
    private final Map<String, Map.Entry<Binder<?, ?, ?>, ConfigurableApplicationContext>> binderInstanceCache = new HashMap();
    private final Map<String, String> defaultBinderForBindingTargetType = new HashMap<String, String>();
    private final BinderTypeRegistry binderTypeRegistry;
    private volatile ConfigurableApplicationContext context;
    private Collection<Listener> listeners;
    private volatile String defaultBinder;

    public DefaultBinderFactory(Map<String, BinderConfiguration> binderConfigurations, BinderTypeRegistry binderTypeRegistry) {
        this.binderConfigurations = new HashMap<String, BinderConfiguration>(binderConfigurations);
        this.binderTypeRegistry = binderTypeRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public void setListeners(Collection<Listener> listeners) {
        this.listeners = listeners;
    }

    public void destroy() {
        this.binderInstanceCache.values().stream().map(Map.Entry::getValue).forEach(ConfigurableApplicationContext::close);
        this.defaultBinderForBindingTargetType.clear();
    }

    public synchronized <T> Binder<T, ?, ?> getBinder(String name, Class<? extends T> bindingTargetType) {
        Binder<? extends T, ConsumerProperties, ProducerProperties> binder;
        Map binders;
        String binderName = StringUtils.hasText((String)name) ? name : this.defaultBinder;
        Map map = binders = this.context == null ? Collections.emptyMap() : this.context.getBeansOfType(Binder.class);
        if (StringUtils.hasText((String)binderName) && binders.containsKey(binderName)) {
            binder = (Binder<? extends T, ConsumerProperties, ProducerProperties>)this.context.getBean(binderName);
        } else if (binders.size() == 1) {
            binder = (Binder)binders.values().iterator().next();
        } else {
            if (binders.size() > 1) {
                throw new IllegalStateException("Multiple binders are available, however neither default nor per-destination binder name is provided. Available binders are " + binders.keySet());
            }
            binder = this.doGetBinder(binderName, bindingTargetType);
        }
        return binder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> Binder<T, ConsumerProperties, ProducerProperties> doGetBinder(String name, Class<? extends T> bindingTargetType) {
        String configurationName;
        block7: {
            block8: {
                block9: {
                    if (!MessageChannel.class.isAssignableFrom(bindingTargetType) && !PollableMessageSource.class.isAssignableFrom(bindingTargetType)) {
                        String bindingTargetTypeName = StringUtils.hasText((String)name) ? name : bindingTargetType.getSimpleName().toLowerCase();
                        return this.getBinderInstance(bindingTargetTypeName);
                    }
                    if (!StringUtils.isEmpty((Object)name)) break block8;
                    Assert.notEmpty(this.binderConfigurations, (String)"A default binder has been requested, but there is no binder available");
                    if (StringUtils.hasText((String)this.defaultBinder)) break block9;
                    HashSet<String> defaultCandidateConfigurations = new HashSet<String>();
                    for (Map.Entry<String, BinderConfiguration> binderConfigurationEntry : this.binderConfigurations.entrySet()) {
                        if (!binderConfigurationEntry.getValue().isDefaultCandidate()) continue;
                        defaultCandidateConfigurations.add(binderConfigurationEntry.getKey());
                    }
                    if (defaultCandidateConfigurations.size() == 1) {
                        configurationName = (String)defaultCandidateConfigurations.iterator().next();
                        this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                        break block7;
                    } else {
                        ArrayList<String> candidatesForBindableType = new ArrayList<String>();
                        for (String defaultCandidateConfiguration : defaultCandidateConfigurations) {
                            Binder<T, ConsumerProperties, ProducerProperties> binderInstance = this.getBinderInstance(defaultCandidateConfiguration);
                            Class<T> binderType = GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0);
                            if (!binderType.isAssignableFrom(bindingTargetType)) continue;
                            candidatesForBindableType.add(defaultCandidateConfiguration);
                        }
                        if (candidatesForBindableType.size() == 1) {
                            configurationName = (String)candidatesForBindableType.iterator().next();
                            this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                            break block7;
                        } else {
                            String countMsg = candidatesForBindableType.size() == 0 ? "are no binders" : "is more than one binder";
                            throw new IllegalStateException("A default binder has been requested, but there " + countMsg + " available for '" + bindingTargetType.getName() + "' : " + StringUtils.collectionToCommaDelimitedString(candidatesForBindableType) + ", and no default binder has been set.");
                        }
                    }
                }
                configurationName = this.defaultBinder;
                break block7;
            }
            configurationName = name;
        }
        Binder<T, ConsumerProperties, ProducerProperties> binderInstance = this.getBinderInstance(configurationName);
        Assert.state((boolean)this.verifyBinderTypeMatchesTarget(binderInstance, bindingTargetType), (String)("The binder '" + configurationName + "' cannot bind a " + bindingTargetType.getName()));
        return binderInstance;
    }

    private <T> boolean verifyBinderTypeMatchesTarget(Binder<T, ?, ?> binderInstance, Class<? extends T> bindingTargetType) {
        return binderInstance instanceof PollableConsumerBinder && GenericsUtils.checkCompatiblePollableBinder(binderInstance, bindingTargetType) || GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0).isAssignableFrom(bindingTargetType);
    }

    private <T> Binder<T, ConsumerProperties, ProducerProperties> getBinderInstance(String configurationName) {
        if (!this.binderInstanceCache.containsKey(configurationName)) {
            ConfigurableApplicationContext binderProducingContext;
            Map messageConverters;
            boolean useApplicationContextAsParent;
            this.logger.info((Object)("Creating binder: " + configurationName));
            BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
            Assert.state((binderConfiguration != null ? 1 : 0) != 0, (String)("Unknown binder configuration: " + configurationName));
            BinderType binderType = this.binderTypeRegistry.get(binderConfiguration.getBinderType());
            Assert.notNull((Object)binderType, (String)("Binder type " + binderConfiguration.getBinderType() + " is not defined"));
            HashMap<String, String> binderProperties = new HashMap<String, String>();
            this.flatten(null, binderConfiguration.getProperties(), binderProperties);
            ArrayList<String> args = new ArrayList<String>();
            for (Map.Entry property : binderProperties.entrySet()) {
                args.add(String.format("--%s=%s", property.getKey(), property.getValue()));
            }
            ConfigurableEnvironment environment = this.context != null ? this.context.getEnvironment() : null;
            String defaultDomain = environment != null ? environment.getProperty("spring.jmx.default-domain") : "";
            args.add("--spring.jmx.default-domain=" + defaultDomain + "binder." + configurationName);
            SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder((Class[])binderType.getConfigurationClasses()).bannerMode(Banner.Mode.OFF).logStartupInfo(false).web(WebApplicationType.NONE);
            boolean bl = useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
            if (useApplicationContextAsParent) {
                springApplicationBuilder.parent(this.context);
            } else {
                this.customizeParentChildContextRelationship(springApplicationBuilder, (ApplicationContext)this.context);
                springApplicationBuilder.listeners(new ApplicationListener[]{new ApplicationListener<ApplicationEvent>(){

                    public void onApplicationEvent(ApplicationEvent event) {
                        if (DefaultBinderFactory.this.context != null) {
                            try {
                                DefaultBinderFactory.this.context.publishEvent(event);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                DefaultBinderFactory.this.logger.warn((Object)("Failed to publish " + event), (Throwable)e);
                            }
                        }
                    }
                }});
            }
            if (environment != null && !useApplicationContextAsParent) {
                springApplicationBuilder.initializers(new ApplicationContextInitializer[]{new InitializerWithOuterContext((ApplicationContext)this.context)});
            }
            if (environment != null && (useApplicationContextAsParent || binderConfiguration.isInheritEnvironment())) {
                StandardEnvironment binderEnvironment = new StandardEnvironment();
                binderEnvironment.merge(environment);
                binderEnvironment.getPropertySources().remove("configurationProperties");
                binderEnvironment.getPropertySources().addFirst((PropertySource)new MapPropertySource("defaultBinderFactoryProperties", Collections.singletonMap("spring.main.web-application-type", "NONE")));
                springApplicationBuilder.environment((ConfigurableEnvironment)binderEnvironment);
            }
            if (!CollectionUtils.isEmpty((Map)(messageConverters = (binderProducingContext = springApplicationBuilder.run(args.toArray(new String[0]))).getBeansOfType(MessageConverter.class))) && !ObjectUtils.isEmpty((Object)this.context.getBeansOfType(FunctionCatalog.class))) {
                FunctionCatalog functionCatalog = (FunctionCatalog)this.context.getBean(FunctionCatalog.class);
                try {
                    Field field = ReflectionUtils.findField(functionCatalog.getClass(), (String)"messageConverter");
                    field.setAccessible(true);
                    CompositeMessageConverter mc = (CompositeMessageConverter)field.get(functionCatalog);
                    mc.getConverters().addAll(0, messageConverters.values());
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Failed to add additional Message Converters from child context", (Throwable)e);
                }
            }
            Binder binder = (Binder)binderProducingContext.getBean(Binder.class);
            if (this.context != null && binder instanceof ApplicationContextAware) {
                ((ApplicationContextAware)binder).setApplicationContext((ApplicationContext)this.context);
            }
            if (!CollectionUtils.isEmpty(this.listeners)) {
                for (Listener binderFactoryListener : this.listeners) {
                    binderFactoryListener.afterBinderContextInitialized(configurationName, binderProducingContext);
                }
            }
            this.logger.info((Object)("Caching the binder: " + configurationName));
            this.binderInstanceCache.put(configurationName, new AbstractMap.SimpleImmutableEntry<Binder, ConfigurableApplicationContext>(binder, binderProducingContext));
        }
        this.logger.info((Object)("Retrieving cached binder: " + configurationName));
        return this.binderInstanceCache.get(configurationName).getKey();
    }

    private void customizeParentChildContextRelationship(SpringApplicationBuilder applicationBuilder, ApplicationContext context) {
        if (context != null) {
            Map customizers = context.getBeansOfType(ListenerContainerCustomizer.class);
            applicationBuilder.initializers(new ApplicationContextInitializer[]{childContext -> {
                if (!CollectionUtils.isEmpty((Map)customizers)) {
                    for (final Map.Entry customizerEntry : customizers.entrySet()) {
                        ListenerContainerCustomizer customizerWrapper = new ListenerContainerCustomizer(){

                            public void configure(Object container, String destinationName, String group) {
                                try {
                                    ((ListenerContainerCustomizer)customizerEntry.getValue()).configure(container, destinationName, group);
                                }
                                catch (Exception e) {
                                    DefaultBinderFactory.this.logger.warn((Object)("Failed while applying ListenerContainerCustomizer. In situations when multiple binders are used this is expected, since a particular customizer may not be applicableto a particular binder. Customizer: " + customizerEntry.getValue() + " Binder: " + childContext.getBean(AbstractMessageChannelBinder.class)), (Throwable)e);
                                }
                            }
                        };
                        ((GenericApplicationContext)childContext).registerBean((String)customizerEntry.getKey(), ListenerContainerCustomizer.class, () -> customizerWrapper, new BeanDefinitionCustomizer[0]);
                    }
                }
                GenericConversionService cs = (GenericConversionService)((GenericApplicationContext)childContext).getBeanFactory().getConversionService();
                SpelExpressionConverterConfiguration.SpelConverter spelConverter = new SpelExpressionConverterConfiguration.SpelConverter();
                cs.addConverter((Converter)spelConverter);
            }});
        }
    }

    private void flatten(String propertyName, Object value, Map<String, String> flattenedProperties) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.flatten((propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    private static class InitializerWithOuterContext
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext context;

        InitializerWithOuterContext(ApplicationContext context) {
            this.context = context;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.getBeanFactory().registerSingleton("outerContext", (Object)this.context);
        }
    }

    public static interface Listener {
        public void afterBinderContextInitialized(String var1, ConfigurableApplicationContext var2);
    }
}

