/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import jodd.log.Logger;
import jodd.log.LoggerProvider;
import jodd.log.impl.SimpleLoggerProvider;

public class SimpleLogger
implements Logger {
    public static final LoggerProvider<SimpleLogger> PROVIDER = new SimpleLoggerProvider();
    private final String name;
    private Logger.Level level;
    private final SimpleLoggerProvider slf;

    public SimpleLogger(SimpleLoggerProvider simpleLoggerProvider, String name, Logger.Level defaultLevel) {
        this.name = name;
        this.slf = simpleLoggerProvider;
        this.level = defaultLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return level.isEnabledFor(level);
    }

    @Override
    public void log(Logger.Level level, String message) {
        this.print(level, message, null);
    }

    @Override
    public void log(Logger.Level level, String message, Throwable throwable) {
        this.print(level, message, throwable);
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.level = level;
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.Level.TRACE.isEnabledFor(this.level);
    }

    @Override
    public void trace(String message) {
        this.print(Logger.Level.TRACE, message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logger.Level.DEBUG.isEnabledFor(this.level);
    }

    @Override
    public void debug(String message) {
        this.print(Logger.Level.DEBUG, message, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return Logger.Level.INFO.isEnabledFor(this.level);
    }

    @Override
    public void info(String message) {
        this.print(Logger.Level.INFO, message, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return Logger.Level.WARN.isEnabledFor(this.level);
    }

    @Override
    public void warn(String message) {
        this.print(Logger.Level.WARN, message, null);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.print(Logger.Level.WARN, message, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return Logger.Level.ERROR.isEnabledFor(this.level);
    }

    @Override
    public void error(String message) {
        this.print(Logger.Level.ERROR, message, null);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.print(Logger.Level.ERROR, message, throwable);
    }

    protected void print(Logger.Level level, String message, Throwable throwable) {
        if (!this.isEnabled(level)) {
            return;
        }
        StringBuilder msg = new StringBuilder().append(this.slf.getElapsedTime()).append(' ').append('[').append((Object)level).append(']').append(' ').append(this.getCallerClass()).append(' ').append('-').append(' ').append(message);
        System.out.println(msg.toString());
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    protected String getCallerClass() {
        StackTraceElement[] stackTrace;
        Exception exception = new Exception();
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            String className = stackTraceElement.getClassName();
            if (className.equals(SimpleLoggerProvider.class.getName()) || className.equals(SimpleLogger.class.getName())) continue;
            return this.shortenClassName(className) + '.' + stackTraceElement.getMethodName() + ':' + stackTraceElement.getLineNumber();
        }
        return "N/A";
    }

    protected String shortenClassName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return className;
        }
        StringBuilder shortClassName = new StringBuilder(className.length());
        int start = 0;
        while (true) {
            shortClassName.append(className.charAt(start));
            int next = className.indexOf(46, start);
            if (next == lastDotIndex) break;
            start = next + 1;
            shortClassName.append('.');
        }
        shortClassName.append(className.substring(lastDotIndex));
        return shortClassName.toString();
    }
}

