/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.xml;

import java.lang.reflect.Type;
import java.util.Iterator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.escape.EscapeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;

public class JSONXMLSerializer {
    public static String toXml(JSON json) throws JSONException {
        return JSONXMLSerializer.toXml(json, null);
    }

    public static String toXml(JSON json, String tagName) throws JSONException {
        return JSONXMLSerializer.toXml(json, tagName, "content");
    }

    public static String toXml(JSON json, String tagName, String ... contentKeys) throws JSONException {
        if (null == json) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (json instanceof JSONObject) {
            JSONXMLSerializer.appendTag(sb, tagName, false);
            json.asJSONObject().forEach((key, value) -> {
                if (ArrayUtil.contains((Object[])contentKeys, (Object)key)) {
                    if (value instanceof JSONArray) {
                        int i = 0;
                        Iterator<JSON> iterator = ((JSONArray)value).iterator();
                        while (iterator.hasNext()) {
                            JSON val = iterator.next();
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(EscapeUtil.escapeXml((CharSequence)((CharSequence)val.toBean((Type)((Object)String.class)))));
                            ++i;
                        }
                    } else {
                        sb.append(EscapeUtil.escapeXml((CharSequence)((CharSequence)value.toBean((Type)((Object)String.class)))));
                    }
                } else if (StrUtil.isEmptyIfStr((Object)value)) {
                    sb.append(JSONXMLSerializer.wrapWithTag(null, key));
                } else if (value instanceof JSONArray) {
                    Iterator<JSON> iterator = ((JSONArray)value).iterator();
                    while (iterator.hasNext()) {
                        JSON val = iterator.next();
                        if (val instanceof JSONArray) {
                            sb.append(JSONXMLSerializer.wrapWithTag(JSONXMLSerializer.toXml(val, null, contentKeys), key));
                            continue;
                        }
                        sb.append(JSONXMLSerializer.toXml(val, key, contentKeys));
                    }
                } else {
                    sb.append(JSONXMLSerializer.toXml(value, key, contentKeys));
                }
            });
            JSONXMLSerializer.appendTag(sb, tagName, true);
            return sb.toString();
        }
        if (json instanceof JSONArray) {
            Iterator<JSON> iterator = ((JSONArray)json).iterator();
            while (iterator.hasNext()) {
                JSON val = iterator.next();
                sb.append(JSONXMLSerializer.toXml(val, tagName == null ? "array" : tagName, contentKeys));
            }
            return sb.toString();
        }
        return JSONXMLSerializer.wrapWithTag(EscapeUtil.escapeXml((CharSequence)((CharSequence)json.toBean((Type)((Object)String.class)))), tagName);
    }

    private static void appendTag(StringBuilder sb, String tagName, boolean isEndTag) {
        if (StrUtil.isNotBlank((CharSequence)tagName)) {
            sb.append('<');
            if (isEndTag) {
                sb.append('/');
            }
            sb.append(tagName).append('>');
        }
    }

    private static String wrapWithTag(String content, String tagName) {
        if (StrUtil.isBlank((CharSequence)tagName)) {
            return StrUtil.wrap((CharSequence)content, (CharSequence)"\"");
        }
        if (StrUtil.isEmpty((CharSequence)content)) {
            return "<" + tagName + "/>";
        }
        return "<" + tagName + ">" + content + "</" + tagName + ">";
    }
}

