/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.convert.impl.TemporalAccessorConverter;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class TemporalTypeAdapter
implements MatcherJSONSerializer<TemporalAccessor>,
MatcherJSONDeserializer<TemporalAccessor> {
    private static final String YEAR_KEY = "year";
    private static final String MONTH_KEY = "month";
    private static final String DAY_KEY = "day";
    private static final String HOUR_KEY = "hour";
    private static final String MINUTE_KEY = "minute";
    private static final String SECOND_KEY = "second";
    private static final String NANO_KEY = "nano";
    public static final TemporalTypeAdapter INSTANCE = new TemporalTypeAdapter();

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return TemporalAccessor.class.isAssignableFrom(TypeUtil.getClass((Type)deserializeType));
    }

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof TemporalAccessor;
    }

    @Override
    public JSON serialize(TemporalAccessor bean, JSONContext context) {
        JSON contextJson = context.getContextJson();
        if (contextJson instanceof JSONObject) {
            TemporalTypeAdapter.toJSONObject(bean, contextJson.asJSONObject());
            return contextJson;
        }
        if (bean instanceof Month) {
            return context.getOrCreatePrimitive(((Month)bean).getValue());
        }
        if (bean instanceof DayOfWeek) {
            return context.getOrCreatePrimitive(((DayOfWeek)bean).getValue());
        }
        if (bean instanceof MonthDay) {
            return context.getOrCreatePrimitive(((MonthDay)bean).toString());
        }
        String format = (String)ObjUtil.apply((Object)context.config(), JSONConfig::getDateFormat);
        Object value = null == format || "#SSS".equals(format) ? Long.valueOf(TimeUtil.toEpochMilli((TemporalAccessor)bean)) : ("#sss".equals(format) ? Long.valueOf(Math.floorDiv(TimeUtil.toEpochMilli((TemporalAccessor)bean), 1000L)) : TimeUtil.format((TemporalAccessor)bean, (String)format));
        return context.getOrCreatePrimitive(value);
    }

    @Override
    public TemporalAccessor deserialize(JSON json, Type deserializeType) {
        if (json instanceof JSONPrimitive) {
            Object value = ((JSONPrimitive)json).getValue();
            TemporalAccessorConverter converter = new TemporalAccessorConverter((String)Opt.ofNullable((Object)json.config()).map(JSONConfig::getDateFormat).getOrNull());
            return (TemporalAccessor)converter.convert(deserializeType, value);
        }
        Class temporalAccessorClass = TypeUtil.getClass((Type)deserializeType);
        if (json instanceof JSONObject) {
            return TemporalTypeAdapter.fromJSONObject(temporalAccessorClass, json.asJSONObject());
        }
        if (Month.class.equals((Object)temporalAccessorClass)) {
            return Month.of((Integer)json.asJSONPrimitive().getValue());
        }
        if (DayOfWeek.class.equals((Object)temporalAccessorClass)) {
            return DayOfWeek.of((Integer)json.asJSONPrimitive().getValue());
        }
        if (MonthDay.class.equals((Object)temporalAccessorClass)) {
            return MonthDay.parse((CharSequence)json.asJSONPrimitive().getValue());
        }
        throw new JSONException("Unsupported type from JSON {} to {}", json, deserializeType);
    }

    private static void toJSONObject(TemporalAccessor bean, JSONObject json) {
        if (bean instanceof LocalDate) {
            LocalDate localDate = (LocalDate)bean;
            json.putValue(YEAR_KEY, localDate.getYear());
            json.putValue(MONTH_KEY, localDate.getMonthValue());
            json.putValue(DAY_KEY, localDate.getDayOfMonth());
        } else if (bean instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)bean;
            json.putValue(YEAR_KEY, localDateTime.getYear());
            json.putValue(MONTH_KEY, localDateTime.getMonthValue());
            json.putValue(DAY_KEY, localDateTime.getDayOfMonth());
            json.putValue(HOUR_KEY, localDateTime.getHour());
            json.putValue(MINUTE_KEY, localDateTime.getMinute());
            json.putValue(SECOND_KEY, localDateTime.getSecond());
            json.putValue(NANO_KEY, localDateTime.getNano());
        } else if (bean instanceof LocalTime) {
            LocalTime localTime = (LocalTime)bean;
            json.putValue(HOUR_KEY, localTime.getHour());
            json.putValue(MINUTE_KEY, localTime.getMinute());
            json.putValue(SECOND_KEY, localTime.getSecond());
            json.putValue(NANO_KEY, localTime.getNano());
        } else {
            throw new JSONException("Unsupported type: {}", bean.getClass().getName());
        }
    }

    private static TemporalAccessor fromJSONObject(Class<?> temporalAccessorClass, JSONObject jsonObject) {
        if (LocalDate.class.equals(temporalAccessorClass) || LocalDateTime.class.equals(temporalAccessorClass)) {
            Integer day;
            Integer year = jsonObject.getInt(YEAR_KEY);
            Assert.notNull((Object)year, (String)"Field 'year' must be not null", (Object[])new Object[0]);
            String monthStr = jsonObject.getStr(MONTH_KEY);
            Assert.notNull((Object)monthStr, (String)"Field 'month' must be not null", (Object[])new Object[0]);
            Integer month = NumberUtil.parseInt((String)monthStr, null);
            if (null == month) {
                Month monthEnum = Month.valueOf(monthStr);
                month = monthEnum.getValue();
            }
            if (null == (day = jsonObject.getInt(DAY_KEY))) {
                day = jsonObject.getInt("dayOfMonth");
                Assert.notNull((Object)day, (String)"Field 'day' or 'dayOfMonth' must be not null", (Object[])new Object[0]);
            }
            LocalDate localDate = LocalDate.of((int)year, month, (int)day);
            if (LocalDate.class.equals(temporalAccessorClass)) {
                return localDate;
            }
            LocalTime localTime = LocalTime.of(jsonObject.getInt(HOUR_KEY, 0), jsonObject.getInt(MINUTE_KEY, 0), jsonObject.getInt(SECOND_KEY, 0), jsonObject.getInt(NANO_KEY, 0));
            return LocalDateTime.of(localDate, localTime);
        }
        if (LocalTime.class.equals(temporalAccessorClass)) {
            return LocalTime.of(jsonObject.getInt(HOUR_KEY), jsonObject.getInt(MINUTE_KEY), jsonObject.getInt(SECOND_KEY), jsonObject.getInt(NANO_KEY));
        }
        throw new JSONException("Unsupported type from JSON {} to {}", jsonObject, temporalAccessorClass);
    }
}

