/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import org.dromara.hutool.core.convert.impl.CalendarConverter;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class CalendarTypeAdapter
implements MatcherJSONSerializer<Calendar>,
MatcherJSONDeserializer<Calendar> {
    public static final CalendarTypeAdapter INSTANCE = new CalendarTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof Calendar;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return Calendar.class.isAssignableFrom(TypeUtil.getClass((Type)deserializeType));
    }

    @Override
    public JSON serialize(Calendar bean, JSONContext context) {
        JSONConfig config = (JSONConfig)ObjUtil.apply((Object)context, JSONContext::config);
        String format = (String)ObjUtil.apply((Object)config, JSONConfig::getDateFormat);
        return new JSONPrimitive(null == format ? Long.valueOf(bean.getTimeInMillis()) : DateUtil.format((Date)DateUtil.date((Calendar)bean), (String)format), config);
    }

    @Override
    public Calendar deserialize(JSON json, Type deserializeType) {
        JSONConfig config = json.config();
        String format = (String)ObjUtil.apply((Object)config, JSONConfig::getDateFormat);
        return (Calendar)new CalendarConverter(format).convert(deserializeType, json.asJSONPrimitive().getValue());
    }
}

