/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class TemporalMoshiAdapter
extends JsonAdapter<TemporalAccessor> {
    private final Class<? extends TemporalAccessor> type;
    private final String dateFormat;

    public TemporalMoshiAdapter(Class<? extends TemporalAccessor> type, String dateFormat) {
        this.type = type;
        this.dateFormat = dateFormat;
    }

    public void toJson(JsonWriter jsonWriter, TemporalAccessor src) throws IOException {
        if (null == src) {
            jsonWriter.nullValue();
            return;
        }
        if (StrUtil.isEmpty((CharSequence)this.dateFormat)) {
            jsonWriter.value(TimeUtil.toEpochMilli((TemporalAccessor)src));
        } else {
            jsonWriter.value(TimeUtil.format((TemporalAccessor)src, (String)this.dateFormat));
        }
    }

    public TemporalAccessor fromJson(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonReader.Token.NULL) {
            return (TemporalAccessor)jsonReader.nextNull();
        }
        return StrUtil.isEmpty((CharSequence)this.dateFormat) ? (TemporalAccessor)ConvertUtil.convert(this.type, (Object)jsonReader.nextLong()) : (TemporalAccessor)ConvertUtil.convert(this.type, (Object)TimeUtil.parse((CharSequence)jsonReader.nextString(), (String)this.dateFormat));
    }
}

