/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class JacksonTemporalSerializer
extends StdSerializer<TemporalAccessor> {
    private static final long serialVersionUID = 1L;
    private final String format;

    public JacksonTemporalSerializer(String format) {
        super(TemporalAccessor.class);
        this.format = format;
    }

    public void serialize(TemporalAccessor value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (StrUtil.isEmpty((CharSequence)this.format)) {
            long epochMilli = TimeUtil.toEpochMilli((TemporalAccessor)value);
            gen.writeNumber(epochMilli);
        } else {
            gen.writeString(TimeUtil.format((TemporalAccessor)value, (String)this.format));
        }
    }
}

