/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.TimeZone;
import org.dromara.hutool.core.io.stream.UTF8OutputStreamWriter;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.wrapper.Wrapper;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;
import org.dromara.hutool.json.engine.gson.DateGsonTypeAdapter;
import org.dromara.hutool.json.engine.gson.TemporalGsonTypeAdapter;
import org.dromara.hutool.json.engine.gson.TimeZoneGsonTypeAdapter;

public class GsonEngine
extends AbstractJSONEngine
implements Wrapper<Gson> {
    private Gson gson;

    public GsonEngine() {
        Assert.notNull(Gson.class);
    }

    public Gson getRaw() {
        this.initEngine();
        return this.gson;
    }

    @Override
    public void serialize(Object bean, OutputStream out) {
        this.initEngine();
        this.gson.toJson(bean, (Appendable)new UTF8OutputStreamWriter(out));
    }

    @Override
    public String toJsonString(Object bean) {
        this.initEngine();
        return this.gson.toJson(bean);
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        if (type instanceof Class) {
            return (T)this.gson.fromJson(reader, (Class)type);
        }
        if (type instanceof Type) {
            return (T)this.gson.fromJson(reader, (Type)type);
        }
        throw new JSONException("Unsupported type: {}", type.getClass());
    }

    @Override
    protected void reset() {
        this.gson = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.gson) {
            return;
        }
        JSONEngineConfig config = (JSONEngineConfig)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::of);
        GsonBuilder builder = new GsonBuilder();
        if (config.isPrettyPrint()) {
            builder.setPrettyPrinting();
        }
        String dateFormat = config.getDateFormat();
        this.registerDate(builder, dateFormat);
        if (!config.isIgnoreNullValue()) {
            builder.serializeNulls();
        }
        this.gson = builder.create();
    }

    private void registerDate(GsonBuilder builder, String dateFormat) {
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateGsonTypeAdapter(dateFormat));
        builder.registerTypeHierarchyAdapter(TimeZone.class, (Object)TimeZoneGsonTypeAdapter.INSTANCE);
        builder.registerTypeAdapter(LocalDateTime.class, (Object)new TemporalGsonTypeAdapter(LocalDateTime.class, dateFormat));
        builder.registerTypeAdapter(LocalDate.class, (Object)new TemporalGsonTypeAdapter(LocalDate.class, dateFormat));
        builder.registerTypeAdapter(LocalTime.class, (Object)new TemporalGsonTypeAdapter(LocalTime.class, dateFormat));
    }
}

