/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.jetbrick;

import java.util.Properties;
import jetbrick.template.JetEngine;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.jetbrick.JetbrickTemplate;

public class JetbrickEngine
implements TemplateEngine {
    private JetEngine engine;

    public JetbrickEngine() {
        Assert.notNull(JetbrickEngine.class);
    }

    public JetbrickEngine(TemplateConfig config) {
        this.init(config);
    }

    public JetbrickEngine(JetEngine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        this.init(JetbrickEngine.createEngine(config));
        return this;
    }

    private void init(JetEngine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return JetbrickTemplate.wrap(this.engine.getTemplate(resource));
    }

    public JetEngine getRaw() {
        return this.engine;
    }

    private static JetEngine createEngine(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        Properties props = new Properties();
        props.setProperty("jetx.input.encoding", config.getCharsetStr());
        props.setProperty("jetx.output.encoding", config.getCharsetStr());
        props.setProperty("jetx.template.loaders", "$loader");
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                props.setProperty("$loader", "jetbrick.template.loader.ClasspathResourceLoader");
                props.setProperty("$loader.root", config.getPath());
                break;
            }
            case FILE: {
                props.setProperty("$loader", "jetbrick.template.loader.FileSystemResourceLoader");
                props.setProperty("$loader.root", config.getPath());
                break;
            }
            case WEB_ROOT: {
                props.setProperty("$loader", "jetbrick.template.loader.ServletResourceLoader");
                props.setProperty("$loader.root", config.getPath());
                break;
            }
            case STRING: {
                props.setProperty("$loader", "org.dromara.hutool.extra.template.engine.jetbrick.loader.StringResourceLoader");
                props.setProperty("$loader.charset", config.getCharsetStr());
                break;
            }
            default: {
                return JetEngine.create();
            }
        }
        return JetEngine.create((Properties)props);
    }
}

