/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.openssl;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.SpecUtil;
import org.dromara.hutool.crypto.openssl.SaltMagic;

public class OpenSSLPBEOutputStream
extends CipherOutputStream {
    protected static final int WRITE_BLOCK_SIZE = 65536;

    public OpenSSLPBEOutputStream(OutputStream out, String algorithm, int iterationCount, char[] password) {
        super(out, OpenSSLPBEOutputStream.createEncryptCipher(algorithm, OpenSSLPBEOutputStream.writeRandomHeader(out), iterationCount, password));
    }

    private static byte[] writeRandomHeader(OutputStream out) throws IORuntimeException {
        byte[] salt = RandomUtil.randomBytes((int)8);
        try {
            out.write(SaltMagic.SALTED_MAGIC);
            out.write(salt);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return salt;
    }

    private static Cipher createEncryptCipher(String algorithm, byte[] salt, int iterationCount, char[] password) {
        Cipher cipher = SecureUtil.createCipher(algorithm);
        try {
            cipher.init(1, (Key)KeyUtil.generatePBEKey(algorithm, password), SpecUtil.createPBEParameterSpec(salt, iterationCount));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }
}

