/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.reader.sheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.func.SerBiConsumer;
import org.dromara.hutool.poi.excel.cell.CellUtil;
import org.dromara.hutool.poi.excel.cell.editors.CellEditor;
import org.dromara.hutool.poi.excel.reader.sheet.AbstractSheetReader;

public class WalkSheetReader
extends AbstractSheetReader<Void> {
    private final SerBiConsumer<Cell, Object> cellHandler;

    public WalkSheetReader(int startRowIndex, int endRowIndex, SerBiConsumer<Cell, Object> cellHandler) {
        super(startRowIndex, endRowIndex);
        this.cellHandler = cellHandler;
    }

    @Override
    public Void read(Sheet sheet) {
        int startRowIndex = Math.max(this.cellRangeAddress.getFirstRow(), sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), sheet.getLastRowNum());
        CellEditor cellEditor = this.config.getCellEditor();
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = sheet.getRow(y);
            if (null == row) continue;
            short startColumnIndex = (short)Math.max(this.cellRangeAddress.getFirstColumn(), row.getFirstCellNum());
            short endColumnIndex = (short)Math.min(this.cellRangeAddress.getLastColumn(), row.getLastCellNum());
            for (short x = startColumnIndex; x < endColumnIndex; x = (short)(x + 1)) {
                Cell cell = CellUtil.getCell(row, x);
                this.cellHandler.accept(cell, CellUtil.getCellValue(cell, cellEditor));
            }
        }
        return null;
    }
}

