/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.reader.sheet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.poi.excel.reader.ExcelReadConfig;
import org.dromara.hutool.poi.excel.reader.sheet.MapSheetReader;
import org.dromara.hutool.poi.excel.reader.sheet.SheetReader;

public class BeanSheetReader<T>
implements SheetReader<List<T>> {
    private final Class<T> beanClass;
    private final MapSheetReader mapSheetReader;

    public BeanSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanClass) {
        this.mapSheetReader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        this.beanClass = beanClass;
    }

    @Override
    public List<T> read(Sheet sheet) {
        Object mapList = this.mapSheetReader.read(sheet);
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return mapList;
        }
        ArrayList<T> beanList = new ArrayList<T>(mapList.size());
        CopyOptions copyOptions = CopyOptions.of().setIgnoreError(true);
        Iterator iterator = mapList.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            beanList.add(BeanUtil.toBean((Object)map, this.beanClass, copyOptions));
        }
        return beanList;
    }

    public void setExcelConfig(ExcelReadConfig config) {
        this.mapSheetReader.setExcelConfig(config);
    }
}

