/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.csv;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.collection.ListWrapper;
import org.dromara.hutool.core.lang.Assert;

public final class CsvRow
extends ListWrapper<String> {
    private final long originalLineNumber;
    final Map<String, Integer> headerMap;

    public CsvRow(long originalLineNumber, Map<String, Integer> headerMap, List<String> fields) {
        super(Assert.notNull(fields, "fields must be not null!", new Object[0]));
        this.originalLineNumber = originalLineNumber;
        this.headerMap = headerMap;
    }

    public long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public String getByName(String name) {
        Assert.notNull(this.headerMap, "No header available!", new Object[0]);
        Integer col = this.headerMap.get(name);
        if (col != null) {
            return this.get(col);
        }
        return null;
    }

    public Map<String, String> getFieldMap() {
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>(this.headerMap.size(), 1.0f);
        for (Map.Entry<String, Integer> header : this.headerMap.entrySet()) {
            String key = header.getKey();
            Integer col = this.headerMap.get(key);
            String val = null == col ? null : this.get(col);
            fieldMap.put(key, val);
        }
        return fieldMap;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.toBean(this.getFieldMap(), clazz, CopyOptions.of().setIgnoreError(true));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return new HashSet((Collection)this.raw).containsAll(c);
    }

    @Override
    public String get(int index) {
        return index >= this.size() ? null : (String)super.get(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CsvRow{");
        sb.append("originalLineNumber=");
        sb.append(this.originalLineNumber);
        sb.append(", ");
        sb.append("fields=");
        if (this.headerMap != null) {
            sb.append('{');
            Iterator<Map.Entry<String, String>> it = this.getFieldMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.append(entry.getKey());
                sb.append('=');
                if (entry.getValue() != null) {
                    sb.append(entry.getValue());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
        } else {
            sb.append(((List)this.raw).toString());
        }
        sb.append('}');
        return sb.toString();
    }
}

