/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.writer;

import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.writer.JSONValueWriter;
import org.dromara.hutool.json.writer.JSONWriter;
import org.dromara.hutool.json.writer.NumberWriteMode;

public class NumberValueWriter
implements JSONValueWriter {
    private static final long JS_MAX_NUMBER = 0x20000000000000L;
    public static final NumberValueWriter INSTANCE = new NumberValueWriter();

    @Override
    public boolean test(Object value) {
        if (value instanceof Number) {
            if (!NumberUtil.isValidNumber((Number)value)) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
            return true;
        }
        return false;
    }

    @Override
    public void write(JSONWriter writer, Object value) {
        JSONConfig config = writer.getConfig();
        boolean isStripTrailingZeros = null == config || config.isStripTrailingZeros();
        Number number = (Number)value;
        String numberStr = NumberUtil.toStr(number, isStripTrailingZeros);
        NumberWriteMode numberWriteMode = null == config ? NumberWriteMode.NORMAL : config.getNumberWriteMode();
        switch (numberWriteMode) {
            case JS: {
                if (number.longValue() > 0x20000000000000L) {
                    writer.writeQuoteStrValue(numberStr);
                    break;
                }
                writer.writeRaw(numberStr);
                break;
            }
            case STRING: {
                writer.writeQuoteStrValue(numberStr);
                break;
            }
            default: {
                writer.writeRaw(numberStr);
            }
        }
    }
}

