/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.BeanCopier;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.RegisterConverter;
import org.dromara.hutool.core.convert.SpecialConverter;
import org.dromara.hutool.core.convert.impl.DateConverter;
import org.dromara.hutool.core.convert.impl.TemporalAccessorConverter;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.map.MapWrapper;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.reflect.kotlin.KClassUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONGetter;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONParser;
import org.dromara.hutool.json.JSONTokener;
import org.dromara.hutool.json.convert.JSONGetterValueProvider;
import org.dromara.hutool.json.serialize.JSONDeserializer;
import org.dromara.hutool.json.serialize.JSONStringer;

public class JSONConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final JSONConverter INSTANCE = new JSONConverter(null);
    private final JSONConfig config;

    public static JSONConverter of(JSONConfig config) {
        return new JSONConverter(config);
    }

    public JSONConverter(JSONConfig config) {
        this.config = config;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (value instanceof JSONStringer) {
            value = ((JSONStringer)value).getRaw();
        }
        if (value instanceof JSON) {
            if (targetType instanceof TypeReference) {
                targetType = ((TypeReference)targetType).getType();
            }
            return this.toBean(targetType, (JSON)value);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        if (null != targetClass) {
            Object date;
            if (JSON.class.isAssignableFrom(targetClass)) {
                return this.toJSON(value);
            }
            if ((Date.class.isAssignableFrom(targetClass) || TemporalAccessor.class.isAssignableFrom(targetClass)) && null != (date = this.toDateWithFormat(targetClass, value))) {
                return date;
            }
        }
        return ConvertUtil.convertWithCheck(targetType, value, null, this.config.isIgnoreError());
    }

    public Object toJSON(Object obj) throws JSONException {
        if (null == obj) {
            return null;
        }
        if (obj instanceof Optional) {
            obj = ((Optional)obj).orElse(null);
        } else if (obj instanceof Opt) {
            obj = ((Opt)obj).getOrNull();
        }
        if (obj instanceof JSON || obj instanceof Number || obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof CharSequence) {
            return this.toJSON((CharSequence)obj);
        }
        JSONGetter<String> json = obj instanceof MapWrapper ? new JSONObject(obj, this.config) : (obj instanceof Iterable || obj instanceof Iterator || ArrayUtil.isArray(obj) ? new JSONArray(obj, this.config) : new JSONObject(obj, this.config));
        return json;
    }

    public Object toJSON(CharSequence str) throws JSONException {
        if (null == str) {
            return null;
        }
        String jsonStr = StrUtil.trim(str);
        if (jsonStr.isEmpty()) {
            return null;
        }
        char firstC = jsonStr.charAt(0);
        JSONParser jsonParser = JSONParser.of(new JSONTokener(jsonStr), this.config);
        Object value = jsonParser.nextValue();
        if (jsonParser.getTokener().nextClean() != '\u0000') {
            throw new JSONException("JSON format error: {}", jsonStr);
        }
        switch (firstC) {
            case '\"': 
            case '\'': {
                return InternalJSONUtil.quote((CharSequence)value);
            }
        }
        if (ObjUtil.equals(jsonStr, value)) {
            return InternalJSONUtil.quote((CharSequence)value);
        }
        return value;
    }

    private <T> T toBean(Type targetType, JSON json) {
        JSONDeserializer deserializer = InternalJSONUtil.getDeserializer(targetType);
        if (null != deserializer) {
            return deserializer.deserialize(json);
        }
        Class<?> rawType = TypeUtil.getClass(targetType);
        if (null == rawType) {
            return (T)json;
        }
        if (KClassUtil.isKotlinClass(rawType) && json instanceof JSONGetter) {
            return (T)KClassUtil.newInstance(rawType, new JSONGetterValueProvider<String>((JSONGetter)((Object)json)));
        }
        Converter converter = RegisterConverter.getInstance().getConverter(targetType, json, true);
        if (null != converter) {
            return (T)converter.convert(targetType, json);
        }
        Object result = SpecialConverter.getInstance().convert(targetType, rawType, json);
        if (null != result) {
            return (T)result;
        }
        if (BeanUtil.isWritableBean(rawType)) {
            return (T)BeanCopier.of(json, ConstructorUtil.newInstanceIfPossible(rawType), targetType, InternalJSONUtil.toCopyOptions(json.config())).copy();
        }
        if (json.config().isIgnoreError()) {
            return null;
        }
        throw new JSONException("Can not convert from '{}': {} to '{}'", json.getClass().getName(), json, targetType.getTypeName());
    }

    private Object toDateWithFormat(Class<?> targetClass, Object value) {
        String format = this.config.getDateFormat();
        if (StrUtil.isNotBlank(format)) {
            if (Date.class.isAssignableFrom(targetClass)) {
                return new DateConverter(format).convert(targetClass, value);
            }
            return new TemporalAccessorConverter(format).convert(targetClass, value);
        }
        return null;
    }

    static {
        RegisterConverter converter = RegisterConverter.getInstance();
        converter.register((Type)((Object)JSONObject.class), INSTANCE);
        converter.register((Type)((Object)JSONArray.class), INSTANCE);
    }
}

