/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONStrFormatter;
import org.dromara.hutool.json.convert.JSONConverter;
import org.dromara.hutool.json.serialize.GlobalSerializeMapping;
import org.dromara.hutool.json.serialize.JSONArraySerializer;
import org.dromara.hutool.json.serialize.JSONDeserializer;
import org.dromara.hutool.json.serialize.JSONObjectSerializer;
import org.dromara.hutool.json.writer.GlobalValueWriters;
import org.dromara.hutool.json.writer.JSONValueWriter;
import org.dromara.hutool.json.writer.JSONWriter;
import org.dromara.hutool.json.xml.JSONXMLUtil;

public class JSONUtil {
    public static JSONObject ofObj() {
        return new JSONObject();
    }

    public static JSONObject ofObj(JSONConfig config) {
        return new JSONObject(config);
    }

    public static JSONArray ofArray() {
        return new JSONArray();
    }

    public static JSONArray ofArray(JSONConfig config) {
        return new JSONArray(config);
    }

    public static JSONObject parseObj(Object obj) {
        return new JSONObject(obj);
    }

    public static JSONObject parseObj(Object obj, JSONConfig config) {
        return new JSONObject(obj, config);
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue) {
        return new JSONObject(obj, JSONConfig.of().setIgnoreNullValue(ignoreNullValue));
    }

    public static JSONArray parseArray(Object arrayOrCollection) {
        return new JSONArray(arrayOrCollection);
    }

    public static JSONArray parseArray(Object arrayOrCollection, JSONConfig config) {
        return new JSONArray(arrayOrCollection, config);
    }

    public static Object parse(Object obj) {
        return JSONUtil.parse(obj, null);
    }

    public static Object parse(Object obj, JSONConfig config) {
        if (null == config) {
            return JSONConverter.INSTANCE.toJSON(obj);
        }
        return JSONConverter.of(config).toJSON(obj);
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return JSONXMLUtil.toJSONObject(xmlStr);
    }

    public static JSON readJSON(File file, Charset charset) throws IORuntimeException {
        return (JSON)FileUtil.read(file, charset, JSONUtil::parse);
    }

    public static JSONObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        return FileUtil.read(file, charset, JSONUtil::parseObj);
    }

    public static JSONArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        return FileUtil.read(file, charset, JSONUtil::parseArray);
    }

    public static String toJsonPrettyStr(Object obj) {
        if ((obj = JSONUtil.parse(obj)) instanceof JSON) {
            return ((JSON)obj).toStringPretty();
        }
        return StrUtil.toStringOrNull(obj);
    }

    public static String toJsonStr(Object obj) {
        return JSONUtil.toJsonStr(obj, (JSONConfig)null);
    }

    public static String toJsonStr(Object obj, JSONConfig jsonConfig) {
        JSONValueWriter valueWriter = GlobalValueWriters.get(obj);
        if (null != valueWriter) {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = JSONWriter.of(stringWriter, 0, 0, null);
            valueWriter.write(jsonWriter, obj);
            return stringWriter.toString();
        }
        if (null == obj) {
            return null;
        }
        return JSONUtil.parse(obj, jsonConfig).toString();
    }

    public static void toJsonStr(Object obj, Writer writer) {
        if (null != obj) {
            if ((obj = JSONUtil.parse(obj)) instanceof JSON) {
                ((JSON)obj).write(writer);
            }
            try {
                writer.write(obj.toString());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static String toXmlStr(JSON json) {
        return JSONXMLUtil.toXml(json);
    }

    public static JSONObject xmlToJson(String xml) {
        return JSONXMLUtil.toJSONObject(xml);
    }

    public static <T> T toBean(Object json, Class<T> clazz) {
        Assert.notNull(clazz);
        return JSONUtil.toBean(json, clazz);
    }

    public static <T> T toBean(Object json, TypeReference<T> typeReference) {
        Assert.notNull(typeReference);
        return JSONUtil.toBean(json, typeReference.getType());
    }

    public static <T> T toBean(Object json, Type type) {
        return JSONUtil.toBean(json, null, type);
    }

    public static <T> T toBean(Object json, JSONConfig config, Type type) {
        if (null == json) {
            return null;
        }
        if ((json = JSONUtil.parse(json, config)) instanceof JSON) {
            if (type instanceof TypeReference) {
                type = ((TypeReference)type).getType();
            }
            return ((JSON)json).toBean(type);
        }
        return ConvertUtil.convert(type, json);
    }

    public static <T> List<T> toList(String jsonArray, Class<T> elementType) {
        return JSONUtil.toList(JSONUtil.parseArray(jsonArray), elementType);
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return null == jsonArray ? null : jsonArray.toList(elementType);
    }

    public static Object getByPath(JSON json, String expression) {
        return JSONUtil.getByPath(json, expression, null);
    }

    public static <T> T getByPath(JSON json, String expression, T defaultValue) {
        if (null == json || StrUtil.isBlank(expression)) {
            return defaultValue;
        }
        if (null != defaultValue) {
            Class<?> type = defaultValue.getClass();
            return ObjUtil.defaultIfNull(json.getByPath(expression, type), defaultValue);
        }
        return (T)json.getByPath(expression);
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormatter.INSTANCE.format(jsonStr);
    }

    public static boolean isEmpty(JSON json) {
        if (null == json) {
            return true;
        }
        if (json instanceof JSONObject) {
            return ((JSONObject)json).isEmpty();
        }
        if (json instanceof JSONArray) {
            return ((JSONArray)json).isEmpty();
        }
        return false;
    }

    public static boolean isTypeJSON(String str) {
        return JSONUtil.isTypeJSONObject(str) || JSONUtil.isTypeJSONArray(str);
    }

    public static boolean isTypeJSONObject(String str) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(str), '{', '}');
    }

    public static boolean isTypeJSONArray(String str) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(str), '[', ']');
    }

    public static void putSerializer(Type type, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.putSerializer(type, serializer);
    }

    public static void putSerializer(Type type, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.putSerializer(type, serializer);
    }

    public static void putDeserializer(Type type, JSONDeserializer<?> deserializer) {
        GlobalSerializeMapping.putDeserializer(type, deserializer);
    }
}

