/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.multipart;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.multipart.MultipartRequestInputStream;
import org.dromara.hutool.http.multipart.UploadFileHeader;
import org.dromara.hutool.http.multipart.UploadSetting;

public class UploadFile {
    private static final String TMP_FILE_PREFIX = "hutool-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private final UploadFileHeader header;
    private final UploadSetting setting;
    private long size = -1L;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader header, UploadSetting setting) {
        this.header = header;
        this.setting = setting;
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public File write(String destPath) throws IOException {
        if (this.data != null || this.tempFile != null) {
            return this.write(FileUtil.file(destPath));
        }
        return null;
    }

    public File write(File destination) throws IOException {
        this.assertValid();
        if (destination.isDirectory()) {
            destination = new File(destination, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes(this.data, destination);
            this.data = null;
        } else {
            if (null == this.tempFile) {
                throw new NullPointerException("Temp file is null !");
            }
            if (!this.tempFile.exists()) {
                throw new NoSuchFileException("Temp file: [" + this.tempFile.getAbsolutePath() + "] not exist!");
            }
            FileUtil.move(this.tempFile, destination, true);
        }
        return destination;
    }

    public byte[] getFileContent() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes(this.tempFile);
        }
        return null;
    }

    public InputStream getFileInputStream() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.data));
        }
        if (this.tempFile != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    public long size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0L;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processStream(MultipartRequestInputStream input) throws IOException {
        BufferedOutputStream out;
        block8: {
            long maxFileSize;
            block7: {
                boolean bl;
                if (!this.isAllowedExtension()) {
                    this.size = input.skipToBoundary();
                    return false;
                }
                this.size = 0L;
                int memoryThreshold = this.setting.memoryThreshold;
                if (memoryThreshold > 0) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(memoryThreshold);
                    long written = input.copy(baos, memoryThreshold);
                    this.data = baos.toByteArray();
                    if (written <= (long)memoryThreshold) {
                        this.size = this.data.length;
                        return true;
                    }
                }
                this.tempFile = FileUtil.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX, FileUtil.touch(this.setting.tmpUploadPath), false);
                out = FileUtil.getOutputStream(this.tempFile);
                if (this.data != null) {
                    this.size = this.data.length;
                    out.write(this.data);
                    this.data = null;
                }
                maxFileSize = this.setting.maxFileSize;
                try {
                    if (maxFileSize != -1L) break block7;
                    this.size += input.copy(out);
                    bl = true;
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly(out);
                    throw throwable;
                }
                IoUtil.closeQuietly(out);
                return bl;
            }
            this.size += input.copy(out, maxFileSize - this.size + 1L);
            if (this.size <= maxFileSize) break block8;
            this.tempFile.delete();
            this.tempFile = null;
            input.skipToBoundary();
            boolean bl = false;
            IoUtil.closeQuietly(out);
            return bl;
        }
        IoUtil.closeQuietly(out);
        return true;
    }

    private boolean isAllowedExtension() {
        String[] exts = this.setting.fileExts;
        boolean isAllow = this.setting.isAllowFileExts;
        if (exts == null || exts.length == 0) {
            return isAllow;
        }
        String fileNameExt = FileNameUtil.extName(this.getFileName());
        for (String fileExtension : this.setting.fileExts) {
            if (!fileNameExt.equalsIgnoreCase(fileExtension)) continue;
            return isAllow;
        }
        return !isAllow;
    }

    private void assertValid() throws IOException {
        if (!this.isUploaded()) {
            throw new IOException(StrUtil.format("File [{}] upload fail", this.getFileName()));
        }
    }
}

