/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.util.SystemUtil;
import org.dromara.hutool.http.HttpException;

public class HttpUrlConnectionUtil {
    private static final String[] METHODS = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"};

    public static void allowPatchQuietly() {
        try {
            HttpUrlConnectionUtil.allowPatch();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void allowPatch() {
        HttpUrlConnectionUtil.doAllowPatch();
    }

    private static synchronized void doAllowPatch() {
        Field methodsField = FieldUtil.getField(HttpURLConnection.class, "methods");
        if (null == methodsField) {
            throw new HttpException("None static field [methods] with Java version: [{}]", SystemUtil.get("java.version"));
        }
        ModifierUtil.removeFinalModify(methodsField);
        Object staticFieldValue = FieldUtil.getStaticFieldValue(methodsField);
        if (!ArrayUtil.equals(METHODS, staticFieldValue)) {
            FieldUtil.setStaticFieldValue(methodsField, METHODS);
        }
    }

    public static HttpURLConnection openHttp(URL url, Proxy proxy) throws IORuntimeException {
        URLConnection conn = HttpUrlConnectionUtil.openConnection(url, proxy);
        if (!(conn instanceof HttpURLConnection)) {
            throw new HttpException("'{}' of URL [{}] is not a http connection, make sure URL is format for http.", conn.getClass().getName(), url);
        }
        return (HttpURLConnection)conn;
    }

    private static URLConnection openConnection(URL url, Proxy proxy) throws IORuntimeException {
        try {
            return null == proxy ? url.openConnection() : url.openConnection(proxy);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

