/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client;

import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.proxy.HttpProxy;
import org.dromara.hutool.http.ssl.SSLInfo;

public class ClientConfig {
    private int connectionTimeout = HttpGlobalConfig.getTimeout();
    private int readTimeout = HttpGlobalConfig.getTimeout();
    private SSLInfo sslInfo = HttpGlobalConfig.isTrustAnyHost() ? SSLInfo.TRUST_ANY : SSLInfo.DEFAULT;
    private boolean disableCache;
    private HttpProxy proxy;

    public static ClientConfig of() {
        return new ClientConfig();
    }

    public ClientConfig setTimeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ClientConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public SSLInfo getSslInfo() {
        return this.sslInfo;
    }

    public ClientConfig setSSLInfo(SSLInfo sslInfo) {
        this.sslInfo = sslInfo;
        return this;
    }

    public ClientConfig enableSSLVerify() {
        return this.setSSLInfo(SSLInfo.DEFAULT);
    }

    public boolean isDisableCache() {
        return this.disableCache;
    }

    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    public HttpProxy getProxy() {
        return this.proxy;
    }

    public ClientConfig setHttpProxy(String host, int port) {
        return this.setProxy(new HttpProxy(host, port));
    }

    public ClientConfig setProxy(HttpProxy proxy) {
        this.proxy = proxy;
        return this;
    }
}

