/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.mina;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.engine.mina.MinaUtil;

public class MinaSession
implements Session {
    private final SshClient sshClient = MinaUtil.openClient();
    private final ClientSession raw;

    public MinaSession(Connector connector) {
        this.sshClient.setForwardingFilter((ForwardingFilter)new AcceptAllForwardingFilter());
        this.raw = MinaUtil.openSession(this.sshClient, connector);
    }

    @Override
    public Object getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && this.raw.isOpen();
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly(new AutoCloseable[]{this.raw});
        if (null != this.sshClient) {
            this.sshClient.stop();
        }
        IoUtil.closeQuietly(new AutoCloseable[]{this.sshClient});
    }

    @Override
    public void bindLocalPort(InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws IORuntimeException {
        try {
            this.raw.startLocalPortForwarding(new SshdSocketAddress(localAddress), new SshdSocketAddress(remoteAddress));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void unBindLocalPort(InetSocketAddress localAddress) throws IORuntimeException {
        try {
            this.raw.stopLocalPortForwarding(new SshdSocketAddress(localAddress));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void bindRemotePort(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws IORuntimeException {
        try {
            this.raw.startRemotePortForwarding(new SshdSocketAddress(remoteAddress), new SshdSocketAddress(localAddress));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void unBindRemotePort(InetSocketAddress remoteAddress) throws IORuntimeException {
        try {
            this.raw.stopRemotePortForwarding(new SshdSocketAddress(remoteAddress));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String exec(String cmd, Charset charset) {
        return this.exec(cmd, charset, System.err);
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        try {
            return this.raw.executeRemoteCommand(cmd, errStream, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        ChannelShell shellChannel;
        try {
            shellChannel = this.raw.createShellChannel();
            if (null != errStream) {
                shellChannel.setErr(errStream);
            }
            shellChannel.open().verify(new CancelOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        IoUtil.writeStrs(shellChannel.getInvertedIn(), charset, false, cmd);
        return IoUtil.read(shellChannel.getInvertedOut(), charset);
    }
}

