/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ftp;

import java.io.File;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.ftp.Ftp;
import org.dromara.hutool.extra.ftp.FtpConfig;
import org.dromara.hutool.extra.ftp.FtpException;

public abstract class AbstractFtp
implements Ftp {
    protected FtpConfig ftpConfig;

    @Override
    public FtpConfig getConfig() {
        return this.ftpConfig;
    }

    protected AbstractFtp(FtpConfig config) {
        this.ftpConfig = config;
    }

    @Override
    public boolean exist(String path) {
        List<String> names;
        if (StrUtil.isBlank(path)) {
            return false;
        }
        if (this.isDir(path)) {
            return true;
        }
        if (CharUtil.isFileSeparator(path.charAt(path.length() - 1))) {
            return false;
        }
        String fileName = FileNameUtil.getName(path);
        if (".".equals(fileName) || "..".equals(fileName)) {
            return false;
        }
        String dir = StrUtil.defaultIfEmpty(StrUtil.removeSuffix(path, fileName), ".");
        if (!this.isDir(dir)) {
            return false;
        }
        try {
            names = this.ls(dir);
        }
        catch (FtpException ignore) {
            return false;
        }
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    @Override
    public void mkDirs(String dir) {
        String[] dirs = StrUtil.trim(dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StrUtil.isEmpty(dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StrUtil.isNotEmpty(s)) continue;
            boolean exist = true;
            try {
                if (!this.cd(s)) {
                    exist = false;
                }
            }
            catch (FtpException e) {
                exist = false;
            }
            if (exist) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public void download(String path, File outFile, String tempFileSuffix) {
        tempFileSuffix = StrUtil.isBlank(tempFileSuffix) ? ".temp" : StrUtil.addPrefixIfNot(tempFileSuffix, ".");
        String fileName = outFile.isDirectory() ? FileNameUtil.getName(path) : outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.isDirectory() ? outFile : outFile.getParentFile(), tempFileName);
        try {
            this.download(path, outFile);
            FileUtil.rename(outFile, fileName, true);
        }
        catch (Throwable e) {
            FileUtil.del(outFile);
            throw new FtpException(e);
        }
    }

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (StrUtil.isEmpty(nameToFind)) {
            return false;
        }
        return CollUtil.contains(names, nameToFind::equalsIgnoreCase);
    }
}

