/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyStoreUtil;
import org.dromara.hutool.crypto.provider.GlobalProviderFactory;

public class CertUtil {
    public static final String TYPE_X509 = "X.509";

    public static Certificate readX509Certificate(InputStream in) {
        return CertUtil.readCertificate(TYPE_X509, in);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return CertUtil.readCertificate(TYPE_X509, in, password, alias);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = KeyStoreUtil.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return CertUtil.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory factory;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            factory = null == provider ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        return factory;
    }
}

