/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.thread.ratelimiter;

import java.io.Closeable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.thread.NamedThreadFactory;
import org.dromara.hutool.core.thread.ratelimiter.RateLimiterConfig;
import org.dromara.hutool.core.thread.ratelimiter.SemaphoreRateLimiter;

public class TokenBucketRateLimiter
extends SemaphoreRateLimiter
implements Closeable {
    protected final ScheduledExecutorService scheduler = TokenBucketRateLimiter.configureScheduler();

    public TokenBucketRateLimiter(RateLimiterConfig config) {
        super(config, null);
        this.scheduleLimitRefresh();
    }

    @Override
    public void refreshLimit() {
        int permitsToFill = this.config.getCapacity() - this.semaphore.availablePermits();
        if (permitsToFill > 0) {
            this.semaphore.release(Math.min(permitsToFill, this.config.getMaxReleaseCount()));
        }
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
    }

    private static ScheduledExecutorService configureScheduler() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("TokenBucketLimiterScheduler-", true);
        return new ScheduledThreadPoolExecutor(1, threadFactory);
    }

    private void scheduleLimitRefresh() {
        if (null == this.scheduler) {
            return;
        }
        long limitRefreshPeriod = this.config.getRefreshPeriod().toNanos();
        this.scheduler.scheduleAtFixedRate(this::refreshLimit, limitRefreshPeriod, limitRefreshPeriod, TimeUnit.NANOSECONDS);
    }
}

