/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map.multi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.func.SerConsumer3;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.map.MapUtil;

public interface Table<R, C, V>
extends Iterable<Cell<R, C, V>> {
    default public boolean contains(R rowKey, C columnKey) {
        return Opt.ofNullable(this.getRow(rowKey)).map(map -> map.containsKey(columnKey)).orElse(false);
    }

    default public boolean containsRow(R rowKey) {
        return Opt.ofNullable(this.rowMap()).map(map -> map.containsKey(rowKey)).getOrNull();
    }

    default public Map<C, V> getRow(R rowKey) {
        return Opt.ofNullable(this.rowMap()).map(map -> (Map)map.get(rowKey)).getOrNull();
    }

    default public Set<R> rowKeySet() {
        return Opt.ofNullable(this.rowMap()).map(Map::keySet).getOrNull();
    }

    public Map<R, Map<C, V>> rowMap();

    default public boolean containsColumn(C columnKey) {
        return Opt.ofNullable(this.columnMap()).map(map -> map.containsKey(columnKey)).getOrNull();
    }

    default public Map<R, V> getColumn(C columnKey) {
        return Opt.ofNullable(this.columnMap()).map(map -> (Map)map.get(columnKey)).getOrNull();
    }

    default public Set<C> columnKeySet() {
        return Opt.ofNullable(this.columnMap()).map(Map::keySet).getOrNull();
    }

    default public List<C> columnKeys() {
        Map<C, Map<R, V>> columnMap = this.columnMap();
        if (MapUtil.isEmpty(columnMap)) {
            return ListUtil.empty();
        }
        ArrayList<C> result = new ArrayList<C>(columnMap.size());
        for (Map.Entry<C, Map<R, V>> cMapEntry : columnMap.entrySet()) {
            result.add(cMapEntry.getKey());
        }
        return result;
    }

    public Map<C, Map<R, V>> columnMap();

    default public boolean containsValue(V value) {
        Collection rows = Opt.ofNullable(this.rowMap()).map(Map::values).getOrNull();
        if (null != rows) {
            for (Map row : rows) {
                if (!row.containsValue(value)) continue;
                return true;
            }
        }
        return false;
    }

    default public V get(R rowKey, C columnKey) {
        return (V)Opt.ofNullable(this.getRow(rowKey)).map(map -> map.get(columnKey)).getOrNull();
    }

    public Collection<V> values();

    public Set<Cell<R, C, V>> cellSet();

    public V put(R var1, C var2, V var3);

    default public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        if (null != table) {
            for (Cell<R, C, V> cell : table.cellSet()) {
                this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
        }
    }

    public V remove(R var1, C var2);

    public boolean isEmpty();

    default public int size() {
        Map<R, Map<C, V>> rowMap = this.rowMap();
        if (MapUtil.isEmpty(rowMap)) {
            return 0;
        }
        int size = 0;
        for (Map<C, V> map : rowMap.values()) {
            size += map.size();
        }
        return size;
    }

    public void clear();

    default public void forEach(SerConsumer3<? super R, ? super C, ? super V> consumer) {
        for (Cell cell : this) {
            consumer.accept(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    public static interface Cell<R, C, V> {
        public R getRowKey();

        public C getColumnKey();

        public V getValue();
    }
}

