/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.util.ObjUtil;

public class BeanMap
implements Map<String, Object> {
    private final Object bean;
    private final Map<String, PropDesc> propDescMap;

    public static BeanMap of(Object bean) {
        return new BeanMap(bean);
    }

    public BeanMap(Object bean) {
        this.bean = bean;
        this.propDescMap = BeanUtil.getBeanDesc(bean.getClass()).getPropMap(false);
    }

    @Override
    public int size() {
        return this.propDescMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.propDescMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.propDescMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (PropDesc propDesc : this.propDescMap.values()) {
            if (!ObjUtil.equals(propDesc.getValue(this.bean), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        PropDesc propDesc = this.propDescMap.get(key);
        if (null != propDesc) {
            return propDesc.getValue(this.bean);
        }
        return null;
    }

    public Object getProperty(String expression) {
        return BeanUtil.getProperty(this.bean, expression);
    }

    @Override
    public Object put(String key, Object value) {
        PropDesc propDesc = this.propDescMap.get(key);
        if (null != propDesc) {
            Object oldValue = propDesc.getValue(this.bean);
            propDesc.setValue(this.bean, value);
            return oldValue;
        }
        return null;
    }

    public void putProperty(String expression, Object value) {
        BeanUtil.setProperty(this.bean, expression, value);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("Can not remove field for Bean!");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Can not clear fields for Bean!");
    }

    @Override
    public Set<String> keySet() {
        return this.propDescMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        for (PropDesc propDesc : this.propDescMap.values()) {
            list.add(propDesc.getValue(this.bean));
        }
        return list;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>(this.size(), 1.0f);
        this.propDescMap.forEach((key, propDesc) -> set.add(new AbstractMap.SimpleEntry<String, Object>((String)key, propDesc.getValue(this.bean))));
        return set;
    }
}

