/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.collection.iter.LineIter;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.io.BomReader;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.NioUtil;
import org.dromara.hutool.core.io.StreamProgress;
import org.dromara.hutool.core.io.copy.FileChannelCopier;
import org.dromara.hutool.core.io.copy.ReaderWriterCopier;
import org.dromara.hutool.core.io.copy.StreamCopier;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.io.stream.StreamReader;
import org.dromara.hutool.core.io.stream.StreamWriter;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class IoUtil
extends NioUtil {
    public static long copy(Reader reader, Writer writer) throws IORuntimeException {
        return IoUtil.copy(reader, writer, 8192);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtil.copy(reader, writer, bufferSize, -1L, streamProgress);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(reader, "Reader is null !", new Object[0]);
        Assert.notNull(writer, "Writer is null !", new Object[0]);
        return new ReaderWriterCopier(bufferSize, count, streamProgress).copy(reader, writer);
    }

    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        return IoUtil.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        return new StreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        return FileChannelCopier.of().copy(in, out);
    }

    public static BufferedReader toUtf8Reader(InputStream in) {
        return IoUtil.toReader(in, CharsetUtil.UTF_8);
    }

    public static BomReader toBomReader(InputStream in) {
        return new BomReader(in);
    }

    public static BufferedReader toReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static OutputStreamWriter toUtf8Writer(OutputStream out) {
        return IoUtil.toWriter(out, CharsetUtil.UTF_8);
    }

    public static OutputStreamWriter toWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String readUtf8(InputStream in) throws IORuntimeException {
        return IoUtil.read(in, CharsetUtil.UTF_8);
    }

    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        return StrUtil.str(IoUtil.readBytes(in), charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IORuntimeException {
        return IoUtil.read(in, true);
    }

    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IORuntimeException {
        return StreamReader.of(in, isClose).read();
    }

    public static String read(Reader reader) throws IORuntimeException {
        return IoUtil.read(reader, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String read(Reader reader, boolean isClose) throws IORuntimeException {
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
            if (!isClose) return builder.toString();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                IoUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(reader);
        return builder.toString();
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        return IoUtil.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws IORuntimeException {
        return StreamReader.of(in, isClose).readBytes();
    }

    public static byte[] readBytes(InputStream in, int length) throws IORuntimeException {
        return StreamReader.of(in, false).readBytes(length);
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IORuntimeException {
        return HexUtil.encodeStr(IoUtil.readBytes(in, length), toLowerCase);
    }

    public static <T> T readObj(InputStream in, Class<?> ... acceptClasses) throws IORuntimeException, HutoolException {
        return StreamReader.of(in, false).readObj(acceptClasses);
    }

    public static <T extends Collection<String>> T readUtf8Lines(InputStream in, T collection) throws IORuntimeException {
        return IoUtil.readLines(in, CharsetUtil.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IORuntimeException {
        return IoUtil.readLines((Reader)IoUtil.toReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws IORuntimeException {
        IoUtil.readLines(reader, collection::add);
        return collection;
    }

    public static void readUtf8Lines(InputStream in, SerConsumer<String> lineHandler) throws IORuntimeException {
        IoUtil.readLines(in, CharsetUtil.UTF_8, lineHandler);
    }

    public static void readLines(InputStream in, Charset charset, SerConsumer<String> lineHandler) throws IORuntimeException {
        IoUtil.readLines((Reader)IoUtil.toReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, SerConsumer<String> lineHandler) throws IORuntimeException {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        for (String line : IoUtil.lineIter(reader)) {
            lineHandler.accept(line);
        }
    }

    public static ByteArrayInputStream toUtf8Stream(String content) {
        return IoUtil.toStream(content, CharsetUtil.UTF_8);
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IoUtil.toStream(ByteUtil.toBytes(content, charset));
    }

    public static InputStream toStream(File file) {
        Assert.notNull(file);
        return IoUtil.toStream(file.toPath());
    }

    public static InputStream toStream(Path path) {
        Assert.notNull(path);
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static ByteArrayInputStream toStream(ByteArrayOutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static ByteArrayInputStream toStream(FastByteArrayOutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedInputStream toBuffered(InputStream in, int bufferSize) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in, bufferSize);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedOutputStream toBuffered(OutputStream out, int bufferSize) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out, bufferSize);
    }

    public static BufferedReader toBuffered(Reader reader) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBuffered(Reader reader, int bufferSize) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, bufferSize);
    }

    public static BufferedWriter toBuffered(Writer writer) {
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter toBuffered(Writer writer, int bufferSize) {
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, bufferSize);
    }

    public static InputStream toMarkSupport(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static Reader toMarkSupport(Reader reader) {
        if (null == reader) {
            return null;
        }
        if (!reader.markSupported()) {
            return new BufferedReader(reader);
        }
        return reader;
    }

    public static PushbackReader toPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    public static InputStream toAvailableStream(InputStream in) {
        if (in instanceof FileInputStream) {
            return in;
        }
        PushbackInputStream pushbackInputStream = IoUtil.toPushbackStream(in, 1);
        try {
            int available = pushbackInputStream.available();
            if (available <= 0) {
                int b = pushbackInputStream.read();
                pushbackInputStream.unread(b);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return pushbackInputStream;
    }

    public static void writeClose(OutputStream out, byte[] content) throws IORuntimeException {
        IoUtil.write(out, true, content);
    }

    public static void write(OutputStream out, byte[] content) throws IORuntimeException {
        IoUtil.write(out, false, content);
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IORuntimeException {
        StreamWriter.of(out, isCloseOut).write(content);
    }

    public static void writeUtf8(OutputStream out, boolean isCloseOut, CharSequence ... contents) throws IORuntimeException {
        IoUtil.writeStrs(out, CharsetUtil.UTF_8, isCloseOut, contents);
    }

    public static void writeStrs(OutputStream out, Charset charset, boolean isCloseOut, CharSequence ... contents) throws IORuntimeException {
        StreamWriter.of(out, isCloseOut).writeStrs(charset, contents);
    }

    public static void writeObjects(OutputStream out, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        StreamWriter.of(out, isCloseOut).writeObjs(contents);
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(Object obj) {
        if (obj instanceof AutoCloseable) {
            IoUtil.closeQuietly((AutoCloseable)obj);
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void nullSafeClose(Closeable closeable) throws IOException {
        if (null != closeable) {
            closeable.close();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IORuntimeException {
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IORuntimeException {
        input1 = IoUtil.toBuffered(input1);
        input2 = IoUtil.toBuffered(input2);
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IORuntimeException {
        BufferedReader br1 = IoUtil.toBuffered(input1);
        BufferedReader br2 = IoUtil.toBuffered(input2);
        try {
            String line1 = br1.readLine();
            String line2 = br2.readLine();
            while (line1 != null && line1.equals(line2)) {
                line1 = br1.readLine();
                line2 = br2.readLine();
            }
            return Objects.equals(line1, line2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static LineIter lineIter(Reader reader) {
        return new LineIter(reader);
    }

    public static LineIter lineIter(InputStream in, Charset charset) {
        return new LineIter(in, charset);
    }

    public static String toStr(ByteArrayOutputStream out, Charset charset) {
        try {
            return out.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }
}

