/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.transaction.Propagation;
import org.babyfish.jimmer.sql.transaction.TxConnectionManager;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTxConnectionManager
implements TxConnectionManager {
    private final ThreadLocal<Scope> scopeLocal = new ThreadLocal();

    @Override
    public final <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
        if (con != null) {
            return block.apply(con);
        }
        return this.executeTransaction(Propagation.SUPPORTS, block);
    }

    @Override
    public final <R> R execute(Function<Connection, R> block) {
        return this.executeTransaction(Propagation.SUPPORTS, block);
    }

    @Override
    public final <R> R executeTransaction(Function<Connection, R> block) {
        return this.executeTransaction(Propagation.REQUIRED, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <R> R executeTransaction(Propagation propagation, Function<Connection, R> block) {
        try {
            Scope parent = this.scopeLocal.get();
            Scope scope = this.createScope(parent, propagation);
            this.scopeLocal.set(scope);
            try {
                R result;
                try {
                    result = this.execute(scope.con, block);
                }
                catch (Error | RuntimeException ex) {
                    scope.terminate(true);
                    throw ex;
                }
                scope.terminate(false);
                R r = result;
                return r;
            }
            finally {
                if (parent != null) {
                    this.scopeLocal.set(parent);
                } else {
                    this.scopeLocal.remove();
                }
            }
        }
        catch (SQLException ex) {
            throw new ExecutionException("JDBC error raised: " + ex.getMessage(), ex);
        }
    }

    protected abstract Connection openConnection() throws SQLException;

    protected void closeConnection(Connection con) throws SQLException {
        con.close();
    }

    protected void startTransaction(Connection con) throws SQLException {
        con.setAutoCommit(false);
    }

    protected void commitTransaction(Connection con) throws SQLException {
        con.commit();
    }

    protected void rollbackTransaction(Connection con) throws SQLException {
        con.rollback();
    }

    protected void abortTransaction(Connection con) throws SQLException {
        con.setAutoCommit(true);
    }

    private Scope createScope(Scope parent, Propagation propagation) throws SQLException {
        switch (propagation) {
            case REQUIRES_NEW: {
                return new Scope(parent, false, true);
            }
            case SUPPORTS: {
                return new Scope(parent, true, parent != null && parent.withTransaction);
            }
            case NOT_SUPPORTED: {
                return new Scope(parent, true, false);
            }
            case MANDATORY: {
                if (parent == null || !parent.withTransaction) {
                    throw new ExecutionException("The transaction propagation is \"MANDATORY\" but there is no transaction context");
                }
                return new Scope(parent, true, true);
            }
            case NEVER: {
                if (parent != null && parent.withTransaction) {
                    throw new ExecutionException("The transaction propagation is \"NEVER\" but there is already a transaction context");
                }
                return new Scope(parent, true, false);
            }
        }
        return new Scope(parent, true, true);
    }

    private class Scope {
        private final Connection con;
        private final boolean withTransaction;
        private final boolean connectionOwner;
        private final boolean transactionOwner;

        Scope(Scope parent, boolean borrow, boolean withTransaction) throws SQLException {
            Connection con;
            if (parent != null && parent.withTransaction && !withTransaction) {
                borrow = false;
            }
            if (parent != null && borrow) {
                con = parent.con;
                this.connectionOwner = false;
            } else {
                con = AbstractTxConnectionManager.this.openConnection();
                this.connectionOwner = true;
            }
            this.withTransaction = withTransaction;
            if (!withTransaction) {
                this.transactionOwner = false;
            } else if (this.connectionOwner) {
                this.transactionOwner = true;
            } else {
                boolean bl = this.transactionOwner = !parent.withTransaction;
            }
            if (this.transactionOwner) {
                try {
                    AbstractTxConnectionManager.this.startTransaction(con);
                }
                catch (Error | RuntimeException | SQLException ex) {
                    AbstractTxConnectionManager.this.closeConnection(con);
                    this.con = null;
                    throw ex;
                }
            }
            this.con = con;
        }

        void terminate(boolean error) throws SQLException {
            Connection con = this.con;
            if (con == null) {
                return;
            }
            try {
                if (this.transactionOwner) {
                    if (error) {
                        AbstractTxConnectionManager.this.rollbackTransaction(con);
                    } else {
                        AbstractTxConnectionManager.this.commitTransaction(con);
                    }
                    if (!this.connectionOwner) {
                        AbstractTxConnectionManager.this.abortTransaction(con);
                    }
                }
            }
            finally {
                if (this.connectionOwner) {
                    AbstractTxConnectionManager.this.closeConnection(con);
                }
            }
        }
    }
}

