/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.sql.runtime.PrettySqlAppender;

public final class SqlFormatter {
    public static final SqlFormatter SIMPLE = new SqlFormatter();
    public static final SqlFormatter PRETTY = new SqlFormatter("    ", 10, 100);
    public static final SqlFormatter INLINE_PRETTY = new SqlFormatter("    ", 10, -1);
    private final PrettySqlAppender prettySqlAppender;
    private final String indent;
    private final int listParamCountInLine;

    protected SqlFormatter() {
        this.indent = "";
        this.listParamCountInLine = 10;
        this.prettySqlAppender = null;
    }

    protected SqlFormatter(String indent, int listParamCountInLine, int maxVariableContentLength) {
        this.indent = indent != null ? indent : "";
        this.listParamCountInLine = Math.max(listParamCountInLine, 1);
        this.prettySqlAppender = maxVariableContentLength == -1 ? PrettySqlAppender.inline() : PrettySqlAppender.comment(Math.max(maxVariableContentLength, 10));
    }

    public static SqlFormatter pretty(String indent, int listParamCountInLine, int maxVariableContentLength) {
        return new SqlFormatter(indent, listParamCountInLine, Math.max(maxVariableContentLength, 10));
    }

    public static SqlFormatter inlinePretty(String indent, int listParamCountInLine) {
        return new SqlFormatter(indent, listParamCountInLine, -1);
    }

    public boolean isPretty() {
        return this.prettySqlAppender != null;
    }

    public String getIndent() {
        return this.indent;
    }

    public int getListParamCountInLine() {
        return this.listParamCountInLine;
    }

    public void append(StringBuilder builder, String sql, List<Object> variables, List<Integer> variablePositions) {
        if (this.prettySqlAppender == null) {
            builder.append(sql);
        }
        this.prettySqlAppender.append(builder, sql, variables, variablePositions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlFormatter that = (SqlFormatter)o;
        if (this.listParamCountInLine != that.listParamCountInLine) {
            return false;
        }
        if (!Objects.equals(this.prettySqlAppender, that.prettySqlAppender)) {
            return false;
        }
        return this.indent.equals(that.indent);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.prettySqlAppender);
        result = 31 * result + this.indent.hashCode();
        result = 31 * result + this.listParamCountInLine;
        return result;
    }

    public String toString() {
        return "SqlFormatter{prettySqlAppender=" + this.prettySqlAppender + ", indent='" + this.indent + '\'' + ", listParamCountInLine=" + this.listParamCountInLine + '}';
    }
}

