/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherUtil;
import org.babyfish.jimmer.sql.runtime.Cursors;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.Readers;
import org.babyfish.jimmer.sql.runtime.TupleCreator;
import org.jetbrains.annotations.Nullable;

public class Selectors {
    private static final AtomicLong CURSOR_ID_SEQUENCE = new AtomicLong();

    private Selectors() {
    }

    public static <R> List<R> select(JSqlClientImplementor sqlClient, Connection con, String sql, List<Object> variables, @Nullable List<Integer> variablePositions, List<Selection<?>> selections, TupleCreator<?> tupleCreator, ExecutionPurpose purpose) {
        List rows = sqlClient.getExecutor().execute(new Executor.Args<List>(sqlClient, con, sql, variables, variablePositions, purpose, null, null, (stmt, args) -> {
            Reader<?> reader = Readers.createReader(sqlClient, selections, tupleCreator);
            return (List)Internal.usingSqlDraftContext(draftCtx -> {
                Reader.Context ctx = new Reader.Context(draftCtx, sqlClient);
                ArrayList results = new ArrayList();
                try (ResultSet resultSet = stmt.executeQuery();){
                    while (resultSet.next()) {
                        results.add(reader.read(resultSet, ctx));
                        ctx.resetCol();
                    }
                }
                return results;
            });
        }));
        FetcherUtil.fetch(sqlClient, con, selections, tupleCreator, rows);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> void forEach(JSqlClientImplementor sqlClient, Connection con, String sql, List<Object> variables, @Nullable List<Integer> variablePositions, List<Selection<?>> selections, TupleCreator<?> tupleCreator, ExecutionPurpose purpose, int batchSize, Consumer<R> consumer) {
        Executor executor = sqlClient.getExecutor();
        long cursorId = CURSOR_ID_SEQUENCE.incrementAndGet();
        Executor.Args<Void> args = new Executor.Args<Void>(sqlClient, con, sql, variables, variablePositions, purpose, null, (stmt, a) -> {
            Reader<?> reader = Readers.createReader(sqlClient, selections, tupleCreator);
            return (Void)Internal.usingSqlDraftContext(draftContext -> {
                Reader.Context ctx = new Reader.Context(draftContext, sqlClient);
                ArrayList results = new ArrayList();
                stmt.setFetchSize(batchSize);
                try (ResultSet resultSet = stmt.executeQuery();){
                    while (resultSet.next()) {
                        results.add(reader.read(resultSet, ctx));
                        ctx.resetCol();
                        if (results.size() < batchSize) continue;
                        FetcherUtil.fetch(sqlClient, con, selections, tupleCreator, results);
                        for (Object result : results) {
                            consumer.accept(result);
                        }
                        results.clear();
                    }
                }
                FetcherUtil.fetch(sqlClient, con, selections, tupleCreator, results);
                for (Object result : results) {
                    consumer.accept(result);
                }
                return null;
            });
        }, cursorId);
        executor.openCursor(cursorId, sql, variables, variablePositions, purpose, args.ctx, sqlClient);
        Long oldCursorId = Cursors.setCurrentCursorId(cursorId);
        try {
            executor.execute(args);
        }
        finally {
            Cursors.setCurrentCursorId(oldCursorId);
        }
    }
}

