/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.Nullable;

public class SavepointManager {
    private SavepointManager() {
    }

    @Nullable
    public static Savepoint setIfNeeded(Connection con, JSqlClientImplementor sqlClient) {
        if (sqlClient.getDialect().isTransactionAbortedByError()) {
            try {
                return con.getAutoCommit() ? null : con.setSavepoint();
            }
            catch (SQLException ex) {
                throw new ExecutionException("Failed to set savepoint", ex);
            }
        }
        return null;
    }

    public static void rollback(ConnectionSupplier con, @Nullable Savepoint savepoint) {
        if (savepoint != null) {
            try {
                con.get().rollback(savepoint);
            }
            catch (SQLException e) {
                throw new ExecutionException("Failed to rollback to savepoint", e);
            }
        }
    }

    public static void release(ConnectionSupplier con, @Nullable Savepoint savepoint) {
        if (savepoint != null) {
            try {
                con.get().releaseSavepoint(savepoint);
            }
            catch (SQLException e) {
                throw new ExecutionException("Failed to release savepoint", e);
            }
        }
    }

    @FunctionalInterface
    public static interface ConnectionSupplier {
        public Connection get() throws SQLException;
    }
}

