/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.embedded.AbstractTypedEmbeddedPropExpression;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherUtil;
import org.babyfish.jimmer.sql.fetcher.impl.JoinFetchFieldVisitor;
import org.babyfish.jimmer.sql.runtime.DynamicEmbeddedReader;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ObjectReader;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.TupleCreator;

class Readers {
    private Readers() {
    }

    public static Reader<?> createReader(JSqlClientImplementor sqlClient, List<Selection<?>> selections, TupleCreator<?> tupleCreator) {
        int size = selections.size();
        if (tupleCreator != null) {
            Reader[] readers = new Reader[size];
            for (int i = 0; i < size; ++i) {
                readers[i] = Readers.createSingleReader(sqlClient, selections.get(i));
            }
            if (FetcherUtil.hasFetchColumns(sqlClient, selections)) {
                return Reader.tuple(readers, null);
            }
            return Reader.tuple(readers, tupleCreator);
        }
        switch (size) {
            case 1: {
                return Readers.createSingleReader(sqlClient, selections.get(0));
            }
            case 2: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)));
            }
            case 3: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)));
            }
            case 4: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)));
            }
            case 5: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)));
            }
            case 6: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)));
            }
            case 7: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)), Readers.createSingleReader(sqlClient, selections.get(6)));
            }
            case 8: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)), Readers.createSingleReader(sqlClient, selections.get(6)), Readers.createSingleReader(sqlClient, selections.get(7)));
            }
            case 9: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)), Readers.createSingleReader(sqlClient, selections.get(6)), Readers.createSingleReader(sqlClient, selections.get(7)), Readers.createSingleReader(sqlClient, selections.get(8)));
            }
        }
        throw new IllegalArgumentException("The selection count must between 1 and 9");
    }

    private static Reader<?> createSingleReader(JSqlClientImplementor sqlClient, Selection<?> selection) {
        ImmutableProp prop;
        if (selection instanceof TableSelection) {
            ImmutableType immutableType = ((TableSelection)((Object)selection)).getImmutableType();
            return sqlClient.getReader(immutableType);
        }
        if (selection instanceof Table) {
            ImmutableType immutableType = ((Table)selection).getImmutableType();
            return sqlClient.getReader(immutableType);
        }
        if (selection instanceof FetcherSelection) {
            Fetcher<?> fetcher = ((FetcherSelection)selection).getFetcher();
            ImmutableType type = fetcher.getImmutableType();
            if (type.isEmbeddable()) {
                return Readers.createDynamicEmbeddableReader(sqlClient, type, fetcher);
            }
            DynamicEntityReaderCreator creator = new DynamicEntityReaderCreator(sqlClient, type);
            creator.visit(fetcher);
            return creator.create();
        }
        ExpressionImplementor unwrapped = (ExpressionImplementor)AbstractTypedEmbeddedPropExpression.unwrap(selection);
        if (unwrapped instanceof PropExpression && (prop = ((PropExpressionImplementor)unwrapped).getProp()).isScalar(TargetLevel.ENTITY) && !prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return sqlClient.getReader(prop);
        }
        return sqlClient.getReader(unwrapped.getType());
    }

    private static Reader<?> createDynamicEmbeddableReader(JSqlClientImplementor sqlClient, ImmutableType type, Fetcher<?> fetcher) {
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>(type.getProps().size());
        ArrayList readers = new ArrayList(type.getProps().size());
        ArrayList<PropId> shownPropIds = null;
        ArrayList<PropId> hiddenPropIds = null;
        if (fetcher == null) {
            for (ImmutableProp prop : type.getProps().values()) {
                Reader<?> reader;
                if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                    reader = Readers.createDynamicEmbeddableReader(sqlClient, prop.getTargetType(), null);
                } else if (!prop.isFormula()) {
                    assert (prop.getSqlTemplate() == null);
                    reader = sqlClient.getReader(prop);
                } else {
                    reader = null;
                }
                if (reader == null) continue;
                props.add(prop);
                readers.add(reader);
            }
        } else {
            for (Field field : fetcher.getFieldMap().values()) {
                Reader<?> reader;
                ImmutableProp prop = field.getProp();
                if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                    reader = Readers.createDynamicEmbeddableReader(sqlClient, prop.getTargetType(), field.getChildFetcher());
                } else if (!prop.isFormula()) {
                    assert (prop.getSqlTemplate() == null);
                    reader = sqlClient.getReader(prop);
                } else {
                    reader = null;
                }
                if (reader != null) {
                    props.add(prop);
                    readers.add(reader);
                }
                if (!prop.getDependencies().isEmpty()) {
                    if (shownPropIds == null) {
                        shownPropIds = new ArrayList<PropId>();
                    }
                    shownPropIds.add(prop.getId());
                }
                if (!field.isImplicit()) continue;
                if (hiddenPropIds == null) {
                    hiddenPropIds = new ArrayList<PropId>();
                }
                hiddenPropIds.add(prop.getId());
            }
        }
        return new DynamicEmbeddedReader(type, props, readers, shownPropIds, hiddenPropIds);
    }

    private static class DynamicEntityReaderCreator
    extends JoinFetchFieldVisitor {
        private final JSqlClientImplementor sqlClient;
        private Args args;

        DynamicEntityReaderCreator(JSqlClientImplementor sqlClient, ImmutableType type) {
            super(sqlClient);
            this.sqlClient = sqlClient;
            this.args = new Args(type);
        }

        @Override
        protected Object enter(Field field) {
            Args parentArgs = this.args;
            this.args = new Args(field.getProp().getTargetType());
            return parentArgs;
        }

        @Override
        protected void leave(Field field, Object enterValue) {
            Args parentArgs = (Args)enterValue;
            ObjectReader subReader = this.args.create(this.sqlClient);
            parentArgs.set(field.getProp(), subReader);
            this.args = parentArgs;
        }

        @Override
        protected void visit(Field field, int depth) {
            ImmutableProp prop = field.getProp();
            if (!prop.isId() && (prop.hasStorage() || prop.getSqlTemplate() != null)) {
                Reader subReader;
                Reader reader = subReader = prop.isEmbedded(EmbeddedLevel.SCALAR) ? Readers.createDynamicEmbeddableReader(this.sqlClient, prop.getTargetType(), field.getChildFetcher()) : this.sqlClient.getReader(prop);
                if (subReader != null) {
                    this.args.set(prop, subReader);
                }
            }
            if (!prop.getDependencies().isEmpty()) {
                this.args.show(prop);
            }
            if (field.isImplicit()) {
                this.args.hide(prop);
            }
        }

        Reader<?> create() {
            return this.args.create(this.sqlClient);
        }

        private static class Args {
            private final ImmutableType type;
            private Map<ImmutableProp, Reader<?>> nonIdReaderMap = Collections.emptyMap();
            private List<PropId> shownPropIds;
            private List<PropId> hiddenPropIds;

            private Args(ImmutableType type) {
                this.type = type;
            }

            void set(ImmutableProp prop, Reader<?> reader) {
                Map<ImmutableProp, Reader<?>> map = this.nonIdReaderMap;
                if (map.isEmpty()) {
                    map = new LinkedHashMap();
                    this.nonIdReaderMap = map;
                }
                map.put(prop, reader);
            }

            void show(ImmutableProp prop) {
                List<PropId> list = this.shownPropIds;
                if (list == null) {
                    this.shownPropIds = list = new ArrayList<PropId>();
                }
                list.add(prop.getId());
            }

            void hide(ImmutableProp prop) {
                List<PropId> list = this.hiddenPropIds;
                if (list == null) {
                    this.hiddenPropIds = list = new ArrayList<PropId>();
                }
                list.add(prop.getId());
            }

            ObjectReader create(JSqlClientImplementor sqlClient) {
                return new ObjectReader(this.type, sqlClient.getReader(this.type.getIdProp()), this.nonIdReaderMap, this.shownPropIds, this.hiddenPropIds);
            }
        }
    }
}

