/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.babyfish.jimmer.DraftConsumerUncheckedException;
import org.babyfish.jimmer.impl.util.CollectionUtils;
import org.babyfish.jimmer.impl.util.PropCache;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.Serialized;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ObjectReader;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.jetbrains.annotations.NotNull;

public class ReaderManager {
    private static final Map<Class<?>, Reader<?>> BASE_READER_MAP;
    private static final Map<Class<?>, Reader<?>> SIMPLE_LIST_READER_MAP;
    private final JSqlClientImplementor sqlClient;
    private final TypeCache<Reader<?>> typeReaderCache = new TypeCache(this::createTypeReader, true);
    private final PropCache<Reader<?>> propReaderCache = new PropCache(this::createPropReader, true);

    public ReaderManager(JSqlClientImplementor sqlClient) {
        this.sqlClient = sqlClient;
    }

    public Reader<?> reader(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        return immutableType != null ? this.reader(immutableType) : this.scalarReader(type);
    }

    public Reader<?> reader(ImmutableType type) {
        return (Reader)this.typeReaderCache.get(type);
    }

    public Reader<?> reader(ImmutableProp prop) {
        return (Reader)this.propReaderCache.get(prop);
    }

    private Reader<?> createPropReader(ImmutableProp prop) {
        if (prop.isColumnDefinition()) {
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                return new FixedEmbeddedReader(prop.getTargetType(), this);
            }
            if (prop.isReference(TargetLevel.ENTITY)) {
                return new ReferenceReader(prop, this);
            }
            return this.scalarReader(prop);
        }
        if (prop.getDeclaringType().isEmbeddable()) {
            return this.scalarReader(prop);
        }
        ImmutableProp idViewBaseProp = prop.getIdViewBaseProp();
        if (idViewBaseProp != null && idViewBaseProp.isColumnDefinition()) {
            return new ReferenceIdViewReader(prop, this);
        }
        SqlTemplate template = prop.getSqlTemplate();
        if (template instanceof FormulaTemplate) {
            return this.scalarReader(prop);
        }
        return null;
    }

    private Reader<?> createTypeReader(ImmutableType immutableType) {
        if (immutableType.isEmbeddable()) {
            return new FixedEmbeddedReader(immutableType, this);
        }
        if (immutableType instanceof AssociationType) {
            return new AssociationReader((AssociationType)immutableType, this);
        }
        if (!immutableType.isEntity()) {
            return null;
        }
        LinkedHashMap nonIdReaderMap = new LinkedHashMap();
        Reader<?> idReader = null;
        for (ImmutableProp prop : immutableType.getSelectableProps().values()) {
            if (prop.isId()) {
                idReader = this.reader(prop);
                continue;
            }
            ImmutableProp idViewProp = prop.getIdViewProp();
            if (idViewProp != null) {
                nonIdReaderMap.put(idViewProp, this.reader(idViewProp));
                continue;
            }
            nonIdReaderMap.put(prop, this.reader(prop));
        }
        return new ObjectReader(immutableType, idReader, nonIdReaderMap, null, null);
    }

    private Reader<?> scalarReader(ImmutableProp prop) {
        ImmutableType immutableType = prop.getTargetType();
        if (immutableType != null && immutableType.isEmbeddable()) {
            return new FixedEmbeddedReader(immutableType, this);
        }
        ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(prop);
        if (scalarProvider != null) {
            return this.scalarProviderReader(scalarProvider);
        }
        if (this.sqlClient.getDialect().isArraySupported()) {
            Reader<?> reader;
            Type argumentType;
            Type genericType;
            Class returnClass = prop.getReturnClass();
            if (prop.getAnnotation(Serialized.class) == null && (returnClass == List.class || returnClass == Collection.class) && (genericType = prop.getGenericType()) instanceof ParameterizedType && (argumentType = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class && (reader = SIMPLE_LIST_READER_MAP.get((Class)argumentType)) != null) {
                return reader;
            }
        }
        return this.scalarReader(prop.getReturnClass());
    }

    private Reader<?> scalarReader(Class<?> type) {
        ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(type);
        if (scalarProvider != null) {
            return this.scalarProviderReader(scalarProvider);
        }
        ImmutableType immutableType = ImmutableType.tryGet(type);
        if (immutableType != null && immutableType.isEmbeddable()) {
            return new FixedEmbeddedReader(immutableType, this);
        }
        Reader<?> reader = this.baseReader(type);
        if (reader == null) {
            throw new IllegalArgumentException("No scalar provider for customized scalar type \"" + type.getName() + "\"");
        }
        return reader;
    }

    @NotNull
    private Reader<?> scalarProviderReader(ScalarProvider<?, ?> scalarProvider) {
        Reader<String> reader;
        if (scalarProvider.isJsonScalar()) {
            reader = scalarProvider.reader();
            if (reader == null) {
                reader = new JsonReader(this.sqlClient.getDialect());
            }
        } else {
            Class<?> sqlType = scalarProvider.getSqlType();
            reader = this.baseReader(sqlType);
            if (reader == null) {
                reader = ReaderManager.unknownSqlTypeReader(sqlType, scalarProvider, this.sqlClient.getDialect());
            }
        }
        return new CustomizedScalarReader(scalarProvider, reader);
    }

    private Reader<?> baseReader(Class<?> type) {
        if (type.isArray()) {
            return type == byte[].class || this.sqlClient.getDialect().isArraySupported() ? BASE_READER_MAP.get(type) : null;
        }
        return BASE_READER_MAP.get(type);
    }

    private static Reader<?> unknownSqlTypeReader(Class<?> sqlType, ScalarProvider<?, ?> provider, Dialect dialect) {
        Reader<?> reader = provider.reader();
        if (reader == null && (reader = dialect.unknownReader(sqlType)) == null) {
            throw new IllegalStateException("There is no reader for unknown type \"" + sqlType.getName() + "\" in both \"" + ScalarProvider.class.getName() + "\" and \"" + dialect.getClass().getName() + "\"");
        }
        return reader;
    }

    public static boolean isStandardScalarType(Class<?> type) {
        return BASE_READER_MAP.containsKey(type);
    }

    static {
        HashMap baseReaderMap = new HashMap();
        baseReaderMap.put(Boolean.TYPE, new BooleanReader());
        baseReaderMap.put(Boolean.class, new BooleanReader());
        baseReaderMap.put(Character.TYPE, new CharReader());
        baseReaderMap.put(Character.class, new CharReader());
        baseReaderMap.put(Byte.TYPE, new ByteReader());
        baseReaderMap.put(Byte.class, new ByteReader());
        baseReaderMap.put(byte[].class, new ByteArrayReader());
        baseReaderMap.put(Byte[].class, new BoxedByteArrayReader());
        baseReaderMap.put(Short.TYPE, new ShortReader());
        baseReaderMap.put(Short.class, new ShortReader());
        baseReaderMap.put(short[].class, new ShortArrayReader());
        baseReaderMap.put(Short[].class, new BoxedShortArrayReader());
        baseReaderMap.put(Integer.TYPE, new IntReader());
        baseReaderMap.put(Integer.class, new IntReader());
        baseReaderMap.put(int[].class, new IntArrayReader());
        baseReaderMap.put(Integer[].class, new BoxedIntArrayReader());
        baseReaderMap.put(Long.TYPE, new LongReader());
        baseReaderMap.put(Long.class, new LongReader());
        baseReaderMap.put(long[].class, new LongArrayReader());
        baseReaderMap.put(Long[].class, new BoxedLongArrayReader());
        baseReaderMap.put(Float.TYPE, new FloatReader());
        baseReaderMap.put(Float.class, new FloatReader());
        baseReaderMap.put(float[].class, new FloatArrayReader());
        baseReaderMap.put(Float[].class, new BoxedFloatArrayReader());
        baseReaderMap.put(Double.TYPE, new DoubleReader());
        baseReaderMap.put(Double.class, new DoubleReader());
        baseReaderMap.put(double[].class, new DoubleArrayReader());
        baseReaderMap.put(Double[].class, new BoxedDoubleArrayReader());
        baseReaderMap.put(BigInteger.class, new BigIntegerReader());
        baseReaderMap.put(BigDecimal.class, new BigDecimalReader());
        baseReaderMap.put(String.class, new StringReader());
        baseReaderMap.put(String[].class, new StringArrayReader());
        baseReaderMap.put(UUID.class, new UUIDReader());
        baseReaderMap.put(UUID[].class, new UUIDArrayReader());
        baseReaderMap.put(Blob.class, new BlobReader());
        baseReaderMap.put(java.sql.Date.class, new SqlDateReader());
        baseReaderMap.put(Time.class, new SqlTimeReader());
        baseReaderMap.put(Timestamp.class, new SqlTimestampReader());
        baseReaderMap.put(Date.class, new DateReader());
        baseReaderMap.put(LocalDate.class, new LocalDateReader());
        baseReaderMap.put(LocalTime.class, new LocalTimeReader());
        baseReaderMap.put(LocalDateTime.class, new LocalDateTimeReader());
        baseReaderMap.put(OffsetDateTime.class, new OffsetDateTimeReader());
        baseReaderMap.put(ZonedDateTime.class, new ZonedDateTimeReader());
        baseReaderMap.put(Instant.class, new InstantReader());
        BASE_READER_MAP = baseReaderMap;
        HashMap simpleListReaderMap = new HashMap();
        simpleListReaderMap.put(Byte.class, new ByteListReader());
        simpleListReaderMap.put(Short.class, new ShortListReader());
        simpleListReaderMap.put(Integer.class, new IntListReader());
        simpleListReaderMap.put(Long.class, new LongListReader());
        simpleListReaderMap.put(Float.class, new FloatListReader());
        simpleListReaderMap.put(Double.class, new DoubleListReader());
        simpleListReaderMap.put(String.class, new StringListReader());
        simpleListReaderMap.put(UUID.class, new UUIDListReader());
        SIMPLE_LIST_READER_MAP = simpleListReaderMap;
    }

    private static class FixedEmbeddedReader
    implements Reader<Object> {
        private static final ImmutableProp[] EMPTY_PROPS = new ImmutableProp[0];
        private static final Reader<?>[] EMPTY_READERS = new Reader[0];
        private final ImmutableType targetType;
        private ImmutableProp[] props;
        private Reader<?>[] readers;

        FixedEmbeddedReader(ImmutableType targetType, ReaderManager readerManager) {
            this.targetType = targetType;
            LinkedHashMap<ImmutableProp, Reader> map = new LinkedHashMap<ImmutableProp, Reader>();
            for (ImmutableProp childProp : targetType.getProps().values()) {
                if (childProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                    map.put(childProp, new FixedEmbeddedReader(childProp.getTargetType(), readerManager));
                    continue;
                }
                if (childProp.isFormula()) continue;
                assert (childProp.getSqlTemplate() == null);
                map.put(childProp, readerManager.scalarReader(childProp));
            }
            this.props = map.keySet().toArray(EMPTY_PROPS);
            this.readers = map.values().toArray(EMPTY_READERS);
        }

        @Override
        public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
            DraftSpi spi = (DraftSpi)this.targetType.getDraftFactory().apply(ctx.draftContext(), null);
            boolean hasNoNull = false;
            boolean hasRequiredNull = false;
            try {
                int size = this.readers.length;
                for (int i = 0; i < size; ++i) {
                    Object value = this.readers[i].read(rs, ctx);
                    if (hasRequiredNull) continue;
                    ImmutableProp prop = this.props[i];
                    if (value == null) {
                        if (prop.isNullable()) {
                            spi.__set(prop.getId(), null);
                            continue;
                        }
                        hasRequiredNull = true;
                        continue;
                    }
                    spi.__set(prop.getId(), value);
                    hasNoNull = true;
                }
            }
            catch (Throwable ex) {
                return DraftConsumerUncheckedException.rethrow((Throwable)ex);
            }
            return hasNoNull && !hasRequiredNull ? ctx.resolve(spi) : null;
        }

        @Override
        public void skip(Reader.Context ctx) {
            for (Reader<?> reader : this.readers) {
                reader.skip(ctx);
            }
        }
    }

    private static class ReferenceReader
    implements Reader<Object> {
        private final ImmutableType targetType;
        private final Reader<?> foreignKeyReader;

        private ReferenceReader(ImmutableProp prop, ReaderManager readerManager) {
            this.targetType = prop.getTargetType();
            this.foreignKeyReader = readerManager.scalarReader(this.targetType.getIdProp());
        }

        @Override
        public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Object fk = this.foreignKeyReader.read(rs, ctx);
            if (fk == null) {
                return null;
            }
            DraftSpi spi = (DraftSpi)this.targetType.getDraftFactory().apply(ctx.draftContext(), null);
            try {
                spi.__set(this.targetType.getIdProp().getId(), fk);
            }
            catch (Throwable ex) {
                throw DraftConsumerUncheckedException.rethrow((Throwable)ex);
            }
            return ctx.resolve(spi);
        }

        @Override
        public void skip(Reader.Context ctx) {
            this.foreignKeyReader.skip(ctx);
        }
    }

    private static class ReferenceIdViewReader
    implements Reader<Object> {
        private final Reader<?> foreignKeyReader;

        private ReferenceIdViewReader(ImmutableProp prop, ReaderManager readerManager) {
            this.foreignKeyReader = readerManager.scalarReader(prop.getIdViewBaseProp().getTargetType().getIdProp());
        }

        @Override
        public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return this.foreignKeyReader.read(rs, ctx);
        }

        @Override
        public void skip(Reader.Context ctx) {
            this.foreignKeyReader.skip(ctx);
        }
    }

    private static class AssociationReader
    implements Reader<Association<?, ?>> {
        private final Reader<?> sourceReader;
        private final Reader<?> targetReader;

        AssociationReader(AssociationType associationType, ReaderManager readerManager) {
            this.sourceReader = new ReferenceReader(associationType.getSourceProp(), readerManager);
            this.targetReader = new ReferenceReader(associationType.getTargetProp(), readerManager);
        }

        @Override
        public Association<?, ?> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Object source = this.sourceReader.read(rs, ctx);
            Object target = this.targetReader.read(rs, ctx);
            return new Association(source, target);
        }

        @Override
        public void skip(Reader.Context ctx) {
            this.sourceReader.skip(ctx);
            this.targetReader.skip(ctx);
        }
    }

    private static class JsonReader
    extends SingleColumnReader<String> {
        private final Dialect dialect;

        private JsonReader(Dialect dialect) {
            this.dialect = dialect;
        }

        @Override
        public String read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return this.dialect.baseValueToJson(rs.getObject(ctx.col(), this.dialect.getJsonBaseType()));
        }
    }

    private static class CustomizedScalarReader<T, S>
    implements Reader<T> {
        private final ScalarProvider<T, S> scalarProvider;
        private final Reader<S> sqlReader;

        CustomizedScalarReader(ScalarProvider<T, S> scalarProvider, Reader<S> sqlReader) {
            this.scalarProvider = scalarProvider;
            this.sqlReader = sqlReader;
        }

        @Override
        public T read(ResultSet rs, Reader.Context ctx) throws SQLException {
            S sqlValue = this.sqlReader.read(rs, ctx);
            try {
                return sqlValue != null ? (T)this.scalarProvider.toScalar(sqlValue) : null;
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot convert \"" + sqlValue + "\" to the jvm type \"" + this.scalarProvider.getScalarType() + "\" by scalar provider \"" + this.scalarProvider + "\"", ex);
            }
        }

        @Override
        public void skip(Reader.Context ctx) {
            this.sqlReader.skip(ctx);
        }
    }

    private static class BooleanReader
    extends SingleColumnReader<Boolean> {
        private BooleanReader() {
        }

        @Override
        public Boolean read(ResultSet rs, Reader.Context ctx) throws SQLException {
            boolean value = rs.getBoolean(ctx.col());
            if (!value && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class CharReader
    extends SingleColumnReader<Character> {
        private CharReader() {
        }

        @Override
        public Character read(ResultSet rs, Reader.Context ctx) throws SQLException {
            String str = rs.getString(ctx.col());
            return str != null ? Character.valueOf(str.charAt(0)) : null;
        }
    }

    private static class ByteReader
    extends SingleColumnReader<Byte> {
        private ByteReader() {
        }

        @Override
        public Byte read(ResultSet rs, Reader.Context ctx) throws SQLException {
            byte value = rs.getByte(ctx.col());
            if (value == 0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class ByteArrayReader
    extends SingleColumnReader<byte[]> {
        private ByteArrayReader() {
        }

        @Override
        public byte[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getBytes(ctx.col());
        }
    }

    private static class BoxedByteArrayReader
    extends SingleColumnReader<Byte[]> {
        private BoxedByteArrayReader() {
        }

        @Override
        public Byte[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (Byte[])ctx.getDialect().getArray(rs, ctx.col(), Byte[].class);
        }
    }

    private static class ShortReader
    extends SingleColumnReader<Short> {
        private ShortReader() {
        }

        @Override
        public Short read(ResultSet rs, Reader.Context ctx) throws SQLException {
            short value = rs.getShort(ctx.col());
            if (value == 0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class ShortArrayReader
    extends SingleColumnReader<short[]> {
        private ShortArrayReader() {
        }

        @Override
        public short[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return ArrayUtils.toPrimitive((Short[])((Short[])ctx.getDialect().getArray(rs, ctx.col(), Short[].class)));
        }
    }

    private static class BoxedShortArrayReader
    extends SingleColumnReader<Short[]> {
        private BoxedShortArrayReader() {
        }

        @Override
        public Short[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (Short[])ctx.getDialect().getArray(rs, ctx.col(), Short[].class);
        }
    }

    private static class IntReader
    extends SingleColumnReader<Integer> {
        private IntReader() {
        }

        @Override
        public Integer read(ResultSet rs, Reader.Context ctx) throws SQLException {
            int value = rs.getInt(ctx.col());
            if (value == 0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class IntArrayReader
    extends SingleColumnReader<int[]> {
        private IntArrayReader() {
        }

        @Override
        public int[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])ctx.getDialect().getArray(rs, ctx.col(), Integer[].class)));
        }
    }

    private static class BoxedIntArrayReader
    extends SingleColumnReader<Integer[]> {
        private BoxedIntArrayReader() {
        }

        @Override
        public Integer[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (Integer[])ctx.getDialect().getArray(rs, ctx.col(), Integer[].class);
        }
    }

    private static class LongReader
    extends SingleColumnReader<Long> {
        private LongReader() {
        }

        @Override
        public Long read(ResultSet rs, Reader.Context ctx) throws SQLException {
            long value = rs.getLong(ctx.col());
            if (value == 0L && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class LongArrayReader
    extends SingleColumnReader<long[]> {
        private LongArrayReader() {
        }

        @Override
        public long[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return ArrayUtils.toPrimitive((Long[])((Long[])ctx.getDialect().getArray(rs, ctx.col(), Long[].class)));
        }
    }

    private static class BoxedLongArrayReader
    extends SingleColumnReader<Long[]> {
        private BoxedLongArrayReader() {
        }

        @Override
        public Long[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (Long[])ctx.getDialect().getArray(rs, ctx.col(), Long[].class);
        }
    }

    private static class FloatReader
    extends SingleColumnReader<Float> {
        private FloatReader() {
        }

        @Override
        public Float read(ResultSet rs, Reader.Context ctx) throws SQLException {
            float value = rs.getFloat(ctx.col());
            if (value == 0.0f && rs.wasNull()) {
                return null;
            }
            return Float.valueOf(value);
        }
    }

    private static class FloatArrayReader
    extends SingleColumnReader<float[]> {
        private FloatArrayReader() {
        }

        @Override
        public float[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return ArrayUtils.toPrimitive((Float[])((Float[])ctx.getDialect().getArray(rs, ctx.col(), Float[].class)));
        }
    }

    private static class BoxedFloatArrayReader
    extends SingleColumnReader<Float[]> {
        private BoxedFloatArrayReader() {
        }

        @Override
        public Float[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (Float[])ctx.getDialect().getArray(rs, ctx.col(), Float[].class);
        }
    }

    private static class DoubleReader
    extends SingleColumnReader<Double> {
        private DoubleReader() {
        }

        @Override
        public Double read(ResultSet rs, Reader.Context ctx) throws SQLException {
            double value = rs.getDouble(ctx.col());
            if (value == 0.0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class DoubleArrayReader
    extends SingleColumnReader<double[]> {
        private DoubleArrayReader() {
        }

        @Override
        public double[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return ArrayUtils.toPrimitive((Double[])((Double[])ctx.getDialect().getArray(rs, ctx.col(), Double[].class)));
        }
    }

    private static class BoxedDoubleArrayReader
    extends SingleColumnReader<Double[]> {
        private BoxedDoubleArrayReader() {
        }

        @Override
        public Double[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (Double[])ctx.getDialect().getArray(rs, ctx.col(), Double[].class);
        }
    }

    private static class BigIntegerReader
    extends SingleColumnReader<BigInteger> {
        private BigIntegerReader() {
        }

        @Override
        public BigInteger read(ResultSet rs, Reader.Context ctx) throws SQLException {
            BigDecimal decimal = rs.getBigDecimal(ctx.col());
            return decimal != null ? decimal.toBigInteger() : null;
        }
    }

    private static class BigDecimalReader
    extends SingleColumnReader<BigDecimal> {
        private BigDecimalReader() {
        }

        @Override
        public BigDecimal read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getBigDecimal(ctx.col());
        }
    }

    private static class StringReader
    extends SingleColumnReader<String> {
        private StringReader() {
        }

        @Override
        public String read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getString(ctx.col());
        }
    }

    private static class StringArrayReader
    extends SingleColumnReader<String[]> {
        private StringArrayReader() {
        }

        @Override
        public String[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (String[])ctx.getDialect().getArray(rs, ctx.col(), String[].class);
        }
    }

    private static class UUIDReader
    extends SingleColumnReader<UUID> {
        private UUIDReader() {
        }

        @Override
        public UUID read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Object obj = rs.getObject(ctx.col());
            if (obj == null) {
                return null;
            }
            if (obj instanceof byte[]) {
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])obj);
                long high = byteBuffer.getLong();
                long low = byteBuffer.getLong();
                return new UUID(high, low);
            }
            return UUID.fromString(obj.toString());
        }
    }

    private static class UUIDArrayReader
    extends SingleColumnReader<UUID[]> {
        private UUIDArrayReader() {
        }

        @Override
        public UUID[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return (UUID[])ctx.getDialect().getArray(rs, ctx.col(), UUID[].class);
        }
    }

    private static class BlobReader
    extends SingleColumnReader<Blob> {
        private BlobReader() {
        }

        @Override
        public Blob read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getBlob(ctx.col());
        }
    }

    private static class SqlDateReader
    extends SingleColumnReader<java.sql.Date> {
        private SqlDateReader() {
        }

        @Override
        public java.sql.Date read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getDate(ctx.col());
        }
    }

    private static class SqlTimeReader
    extends SingleColumnReader<Time> {
        private SqlTimeReader() {
        }

        @Override
        public Time read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getTime(ctx.col());
        }
    }

    private static class SqlTimestampReader
    extends SingleColumnReader<Timestamp> {
        private SqlTimestampReader() {
        }

        @Override
        public Timestamp read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return ctx.getDialect().getTimestamp(rs, ctx.col());
        }
    }

    private static class DateReader
    extends SingleColumnReader<Date> {
        private DateReader() {
        }

        @Override
        public Date read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = ctx.getDialect().getTimestamp(rs, ctx.col());
            return timestamp != null ? Date.from(timestamp.toInstant()) : null;
        }
    }

    private static class LocalDateReader
    extends SingleColumnReader<LocalDate> {
        private LocalDateReader() {
        }

        @Override
        public LocalDate read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = ctx.getDialect().getTimestamp(rs, ctx.col());
            return timestamp != null ? LocalDateTime.ofInstant(timestamp.toInstant(), ctx.getZoneId()).toLocalDate() : null;
        }
    }

    private static class LocalTimeReader
    extends SingleColumnReader<LocalTime> {
        private LocalTimeReader() {
        }

        @Override
        public LocalTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = ctx.getDialect().getTimestamp(rs, ctx.col());
            return timestamp != null ? LocalDateTime.ofInstant(timestamp.toInstant(), ctx.getZoneId()).toLocalTime() : null;
        }
    }

    private static class LocalDateTimeReader
    extends SingleColumnReader<LocalDateTime> {
        private LocalDateTimeReader() {
        }

        @Override
        public LocalDateTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = ctx.getDialect().getTimestamp(rs, ctx.col());
            return timestamp != null ? LocalDateTime.ofInstant(timestamp.toInstant(), ctx.getZoneId()) : null;
        }
    }

    private static class OffsetDateTimeReader
    extends SingleColumnReader<OffsetDateTime> {
        private OffsetDateTimeReader() {
        }

        @Override
        public OffsetDateTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = ctx.getDialect().getTimestamp(rs, ctx.col());
            return timestamp != null ? OffsetDateTime.ofInstant(timestamp.toInstant(), ctx.getZoneId()) : null;
        }
    }

    private static class ZonedDateTimeReader
    extends SingleColumnReader<ZonedDateTime> {
        private ZonedDateTimeReader() {
        }

        @Override
        public ZonedDateTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = ctx.getDialect().getTimestamp(rs, ctx.col());
            return timestamp != null ? ZonedDateTime.ofInstant(timestamp.toInstant(), ctx.getZoneId()) : null;
        }
    }

    private static class InstantReader
    extends SingleColumnReader<Instant> {
        private InstantReader() {
        }

        @Override
        public Instant read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(ctx.col());
            return timestamp != null ? timestamp.toInstant() : null;
        }
    }

    private static class ByteListReader
    extends SingleColumnReader<List<Byte>> {
        private ByteListReader() {
        }

        @Override
        public List<Byte> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((Byte[])ctx.getDialect().getArray(rs, ctx.col(), Byte[].class)));
        }
    }

    private static class ShortListReader
    extends SingleColumnReader<List<Short>> {
        private ShortListReader() {
        }

        @Override
        public List<Short> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((Short[])ctx.getDialect().getArray(rs, ctx.col(), Short[].class)));
        }
    }

    private static class IntListReader
    extends SingleColumnReader<List<Integer>> {
        private IntListReader() {
        }

        @Override
        public List<Integer> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((Integer[])ctx.getDialect().getArray(rs, ctx.col(), Integer[].class)));
        }
    }

    private static class LongListReader
    extends SingleColumnReader<List<Long>> {
        private LongListReader() {
        }

        @Override
        public List<Long> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((Long[])ctx.getDialect().getArray(rs, ctx.col(), Long[].class)));
        }
    }

    private static class FloatListReader
    extends SingleColumnReader<List<Float>> {
        private FloatListReader() {
        }

        @Override
        public List<Float> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((Float[])ctx.getDialect().getArray(rs, ctx.col(), Float[].class)));
        }
    }

    private static class DoubleListReader
    extends SingleColumnReader<List<Double>> {
        private DoubleListReader() {
        }

        @Override
        public List<Double> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((Double[])ctx.getDialect().getArray(rs, ctx.col(), Double[].class)));
        }
    }

    private static class StringListReader
    extends SingleColumnReader<List<String>> {
        private StringListReader() {
        }

        @Override
        public List<String> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((String[])ctx.getDialect().getArray(rs, ctx.col(), String[].class)));
        }
    }

    private static class UUIDListReader
    extends SingleColumnReader<List<UUID>> {
        private UUIDListReader() {
        }

        @Override
        public List<UUID> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return CollectionUtils.toListOrNull((Object[])((UUID[])ctx.getDialect().getArray(rs, ctx.col(), UUID[].class)));
        }
    }

    private static abstract class SingleColumnReader<T>
    implements Reader<T> {
        private SingleColumnReader() {
        }

        @Override
        public void skip(Reader.Context ctx) {
            ctx.col();
        }
    }
}

