/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.sql.runtime.DbLiteral;

abstract class PrettySqlAppender {
    static final int DEFAULT_MAX_VARIABLE_LENGTH = 100;
    private static final Comment DEAULT_COMMENT = new Comment(100);

    PrettySqlAppender() {
    }

    public abstract void append(StringBuilder var1, String var2, List<Object> var3, List<Integer> var4);

    public static PrettySqlAppender comment(int maxVariableLength) {
        return maxVariableLength == 100 ? DEAULT_COMMENT : new Comment(maxVariableLength);
    }

    public static PrettySqlAppender inline() {
        return Inline.INSTANCE;
    }

    private static class Comment
    extends PrettySqlAppender {
        private final int maxVariableContentLength;

        Comment(int maxVariableContentLength) {
            this.maxVariableContentLength = Math.max(maxVariableContentLength, 10);
        }

        @Override
        public void append(StringBuilder builder, String sql, List<Object> variables, List<Integer> variablePositions) {
            int cloneFrom = 0;
            int paramIndex = 0;
            for (int index : variablePositions) {
                builder.append(sql, cloneFrom, index);
                cloneFrom = index;
                builder.append(" /* ");
                this.appendVariable(builder, variables.get(paramIndex++));
                builder.append(" */");
            }
            int len = sql.length();
            if (cloneFrom < len) {
                builder.append(sql, cloneFrom, len);
            }
        }

        private void appendVariable(StringBuilder builder, Object variable) {
            if (variable instanceof DbLiteral) {
                ((DbLiteral)variable).renderToComment(builder);
            } else if (variable instanceof String) {
                String text = (String)variable;
                if (text.length() > this.maxVariableContentLength) {
                    builder.append(text, 0, this.maxVariableContentLength - 3).append("...");
                } else {
                    builder.append(text);
                }
            } else if (variable instanceof byte[]) {
                byte[] arr = (byte[])variable;
                int len = arr.length > this.maxVariableContentLength ? this.maxVariableContentLength - 3 : arr.length;
                builder.append("bytes[");
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(arr[i]);
                }
                if (arr.length > this.maxVariableContentLength) {
                    builder.append(", ...");
                }
                builder.append(']');
            } else {
                builder.append(variable);
            }
        }

        public int hashCode() {
            return this.maxVariableContentLength;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Comment comment = (Comment)o;
            return this.maxVariableContentLength == comment.maxVariableContentLength;
        }

        public String toString() {
            return "Comment{maxVariableContentLength=" + this.maxVariableContentLength + '}';
        }
    }

    private static class Inline
    extends PrettySqlAppender {
        static final Inline INSTANCE = new Inline();
        private static final Map<Class<?>, VariableAppender<?>> APPENDER_MAP;
        private static final DateTimeFormatter DATE_FORMATTER;
        private static final DateTimeFormatter DATE_TIME_FORMATTER;
        private static final VariableAppender<?> ANY_APPENDER;

        private Inline() {
        }

        @Override
        public void append(StringBuilder builder, String sql, List<Object> variables, List<Integer> variablePositions) {
            int cloneFrom = 0;
            int paramIndex = 0;
            for (int index : variablePositions) {
                builder.append(sql, cloneFrom, Inline.jdbcParamIndex(sql, cloneFrom, index));
                cloneFrom = index;
                Inline.appendVariable(builder, variables.get(paramIndex++));
            }
            int len = sql.length();
            if (cloneFrom < len) {
                builder.append(sql, cloneFrom, len);
            }
        }

        private static void appendVariable(StringBuilder builder, Object variable) {
            VariableAppender<?> appender;
            if (variable instanceof DbLiteral) {
                ((DbLiteral)variable).renderValue(builder);
            }
            if ((appender = APPENDER_MAP.get(variable.getClass())) == null) {
                appender = ANY_APPENDER;
            }
            appender.append(builder, variable);
        }

        public int hashCode() {
            return 2;
        }

        public boolean equals(Object obj) {
            return obj instanceof Inline;
        }

        public String toString() {
            return "Inline";
        }

        private static int jdbcParamIndex(String sql, int start, int stop) {
            for (int i = stop - 1; i >= start; --i) {
                if (sql.charAt(i) != '?') continue;
                return i;
            }
            return stop - 1;
        }

        static {
            DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            ANY_APPENDER = new VariableAppender<Object>(){

                @Override
                public void append(StringBuilder builder, Object variable) {
                    builder.append('\'').append(variable).append('\'');
                }
            };
            HashMap map = new HashMap();
            map.put(String.class, new StringAppender());
            map.put(Boolean.class, new BooleanAppender());
            map.put(Character.class, new CharAppender());
            map.put(Byte.class, new ByteAppender());
            map.put(Short.class, new ShortAppender());
            map.put(Integer.class, new IntAppender());
            map.put(Long.class, new LongAppender());
            map.put(Float.class, new FloatAppender());
            map.put(Double.class, new DoubleAppender());
            map.put(java.util.Date.class, new DateAppender());
            map.put(Date.class, new SqlDateAppender());
            map.put(Time.class, new SqlTimeAppender());
            map.put(LocalDate.class, new LocalDateAppender());
            map.put(LocalDateTime.class, new LocalDateTimeAppender());
            map.put(OffsetDateTime.class, new OffsetDateTimeAppender());
            map.put(ZonedDateTime.class, new ZonedDateTimeAppender());
            map.put(byte[].class, new ByteArrayAppender());
            APPENDER_MAP = map;
        }

        private static interface VariableAppender<T> {
            public void append(StringBuilder var1, T var2);
        }

        private static class StringAppender
        implements VariableAppender<String> {
            private StringAppender() {
            }

            @Override
            public void append(StringBuilder builder, String variable) {
                builder.append('\'').append(variable.replace("'", "''")).append('\'');
            }
        }

        private static class BooleanAppender
        implements VariableAppender<Boolean> {
            private BooleanAppender() {
            }

            @Override
            public void append(StringBuilder builder, Boolean variable) {
                builder.append(variable != false ? 1 : 0);
            }
        }

        private static class CharAppender
        implements VariableAppender<Character> {
            private CharAppender() {
            }

            @Override
            public void append(StringBuilder builder, Character variable) {
                builder.append('\'').append(variable.charValue()).append('\'');
            }
        }

        private static class ByteAppender
        implements VariableAppender<Byte> {
            private ByteAppender() {
            }

            @Override
            public void append(StringBuilder builder, Byte variable) {
                builder.append(variable.byteValue());
            }
        }

        private static class ShortAppender
        implements VariableAppender<Short> {
            private ShortAppender() {
            }

            @Override
            public void append(StringBuilder builder, Short variable) {
                builder.append(variable.shortValue());
            }
        }

        private static class IntAppender
        implements VariableAppender<Integer> {
            private IntAppender() {
            }

            @Override
            public void append(StringBuilder builder, Integer variable) {
                builder.append(variable);
            }
        }

        private static class LongAppender
        implements VariableAppender<Long> {
            private LongAppender() {
            }

            @Override
            public void append(StringBuilder builder, Long variable) {
                builder.append(variable);
            }
        }

        private static class FloatAppender
        implements VariableAppender<Float> {
            private FloatAppender() {
            }

            @Override
            public void append(StringBuilder builder, Float variable) {
                builder.append(variable.floatValue());
            }
        }

        private static class DoubleAppender
        implements VariableAppender<Double> {
            private DoubleAppender() {
            }

            @Override
            public void append(StringBuilder builder, Double variable) {
                builder.append(variable);
            }
        }

        private static class DateAppender
        implements VariableAppender<java.util.Date> {
            private DateAppender() {
            }

            @Override
            public void append(StringBuilder builder, java.util.Date variable) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:hh:ss");
                builder.append('\'').append(format.format(variable)).append('\'');
            }
        }

        private static class SqlDateAppender
        implements VariableAppender<Date> {
            private SqlDateAppender() {
            }

            @Override
            public void append(StringBuilder builder, Date variable) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                builder.append('\'').append(format.format(variable)).append('\'');
            }
        }

        private static class SqlTimeAppender
        implements VariableAppender<Time> {
            private SqlTimeAppender() {
            }

            @Override
            public void append(StringBuilder builder, Time variable) {
                SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
                builder.append('\'').append(format.format(variable)).append('\'');
            }
        }

        private static class LocalDateAppender
        implements VariableAppender<LocalDate> {
            private LocalDateAppender() {
            }

            @Override
            public void append(StringBuilder builder, LocalDate variable) {
                builder.append('\'').append(DATE_FORMATTER.format(variable)).append('\'');
            }
        }

        private static class LocalDateTimeAppender
        implements VariableAppender<LocalDateTime> {
            private LocalDateTimeAppender() {
            }

            @Override
            public void append(StringBuilder builder, LocalDateTime variable) {
                builder.append('\'').append(DATE_TIME_FORMATTER.format(variable)).append('\'');
            }
        }

        private static class OffsetDateTimeAppender
        implements VariableAppender<OffsetDateTime> {
            private OffsetDateTimeAppender() {
            }

            @Override
            public void append(StringBuilder builder, OffsetDateTime variable) {
                builder.append('\'').append(DATE_TIME_FORMATTER.format(variable)).append('\'');
            }
        }

        private static class ZonedDateTimeAppender
        implements VariableAppender<ZonedDateTime> {
            private ZonedDateTimeAppender() {
            }

            @Override
            public void append(StringBuilder builder, ZonedDateTime variable) {
                builder.append('\'').append(DATE_TIME_FORMATTER.format(variable)).append('\'');
            }
        }

        private static class ByteArrayAppender
        implements VariableAppender<byte[]> {
            private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

            private ByteArrayAppender() {
            }

            @Override
            public void append(StringBuilder builder, byte[] variable) {
                builder.append("0x");
                for (byte b : variable) {
                    builder.append(CHARS[b >>> 4 & 0xF]);
                    builder.append(CHARS[b & 0xF]);
                }
            }
        }
    }
}

