/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.DraftConsumerUncheckedException;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.jetbrains.annotations.Nullable;

class ObjectReader
implements Reader<Object> {
    private static final Reader<?>[] EMPTY_READERS = new Reader[0];
    private static final PropId[] EMPTY_PROP_IDS = new PropId[0];
    private final ImmutableType type;
    private final Reader<?> idReader;
    private final PropId[] nonIdPropIds;
    private final Reader<?>[] nonIdReaders;
    private final PropId[] idViewPropIds;
    private final PropId[] idViewBasePropIds;
    @Nullable
    private final List<PropId> shownPropIds;
    @Nullable
    private final List<PropId> hiddenPropsIds;

    ObjectReader(ImmutableType type, Reader<?> idReader, Map<ImmutableProp, Reader<?>> nonIdReaders, @Nullable List<PropId> shownPropIds, @Nullable List<PropId> hiddenPropsIds) {
        ArrayList<PropId> idViewPropIds = new ArrayList<PropId>();
        ArrayList<PropId> idViewBasePropIds = new ArrayList<PropId>();
        for (ImmutableProp prop : nonIdReaders.keySet()) {
            ImmutableProp idViewBaseProp = prop.getIdViewBaseProp();
            if (idViewBaseProp == null) continue;
            idViewPropIds.add(prop.getId());
            idViewBasePropIds.add(idViewBaseProp.getId());
        }
        this.type = type;
        this.idReader = idReader;
        this.nonIdPropIds = (PropId[])nonIdReaders.keySet().stream().map(ImmutableProp::getId).toArray(PropId[]::new);
        this.nonIdReaders = nonIdReaders.values().toArray(EMPTY_READERS);
        this.idViewPropIds = idViewPropIds.toArray(EMPTY_PROP_IDS);
        this.idViewBasePropIds = idViewBasePropIds.toArray(EMPTY_PROP_IDS);
        this.shownPropIds = shownPropIds;
        this.hiddenPropsIds = hiddenPropsIds;
    }

    @Override
    public void skip(Reader.Context ctx) {
        this.idReader.skip(ctx);
        for (Reader<?> reader : this.nonIdReaders) {
            reader.skip(ctx);
        }
    }

    @Override
    public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
        Object id = this.idReader.read(rs, ctx);
        if (id == null) {
            for (Reader<?> reader : this.nonIdReaders) {
                reader.skip(ctx);
            }
            return null;
        }
        DraftSpi spi = (DraftSpi)this.type.getDraftFactory().apply(ctx.draftContext(), null);
        spi.__set(this.type.getIdProp().getId(), id);
        try {
            int i;
            int size = this.nonIdReaders.length;
            for (i = 0; i < size; ++i) {
                Object value = this.nonIdReaders[i].read(rs, ctx);
                spi.__set(this.nonIdPropIds[i], value);
            }
            for (i = this.idViewBasePropIds.length - 1; i >= 0; --i) {
                spi.__show(this.idViewPropIds[i], true);
                spi.__show(this.idViewBasePropIds[i], false);
            }
            if (this.shownPropIds != null) {
                for (PropId propId : this.shownPropIds) {
                    spi.__show(propId, true);
                }
            }
            if (this.hiddenPropsIds != null) {
                for (PropId propId : this.hiddenPropsIds) {
                    spi.__show(propId, false);
                }
            }
        }
        catch (Throwable ex) {
            throw DraftConsumerUncheckedException.rethrow((Throwable)ex);
        }
        return ctx.resolve(spi);
    }
}

