/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.babyfish.jimmer.sql.dialect.Dialect;

public class JdbcTypes {
    private static final Map<Class<?>, Integer> SQL_TYPE_MAP;

    public static int toJdbcType(Class<?> type, Dialect dialect) {
        Integer standardJdbcType;
        int jdbcType = dialect.resolveJdbcType(type);
        if (jdbcType == 1111 && (standardJdbcType = SQL_TYPE_MAP.get(type)) != null) {
            return standardJdbcType;
        }
        return jdbcType;
    }

    static {
        HashMap map = new HashMap();
        map.put(String.class, 12);
        map.put(Boolean.TYPE, 16);
        map.put(Boolean.class, 16);
        map.put(Character.TYPE, 1);
        map.put(Character.class, 1);
        map.put(Byte.TYPE, -6);
        map.put(Byte.class, -6);
        map.put(Short.TYPE, 5);
        map.put(Short.class, 5);
        map.put(Integer.TYPE, 4);
        map.put(Integer.class, 4);
        map.put(Long.TYPE, -5);
        map.put(Long.class, -5);
        map.put(Float.TYPE, 6);
        map.put(Float.class, 6);
        map.put(Double.TYPE, 8);
        map.put(Double.class, 8);
        map.put(BigInteger.class, 3);
        map.put(BigDecimal.class, 3);
        map.put(Date.class, 91);
        map.put(Time.class, 92);
        map.put(java.util.Date.class, 93);
        map.put(LocalDate.class, 91);
        map.put(LocalTime.class, 92);
        map.put(LocalDateTime.class, 93);
        map.put(OffsetDateTime.class, 2014);
        map.put(ZonedDateTime.class, 2014);
        map.put(byte[].class, -2);
        SQL_TYPE_MAP = map;
    }
}

