/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.babyfish.jimmer.sql.runtime.AbstractExecutorProxy;
import org.babyfish.jimmer.sql.runtime.Cursors;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorForLog
extends AbstractExecutorProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorForLog.class);
    private static final String REQUEST = "===>";
    private static final String RESPONSE = "<===";
    private final Logger logger;

    public static Executor wrap(Executor raw, Logger logger) {
        return ExecutorForLog.applier(ExecutorForLog.class, p -> p.logger == logger, r -> new ExecutorForLog((Executor)r, logger)).applyTo(raw);
    }

    private ExecutorForLog(Executor raw, Logger logger) {
        super(raw);
        this.logger = logger != null ? logger : LOGGER;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public <R> R execute(@NotNull Executor.Args<R> args) {
        if (!this.logger.isInfoEnabled()) {
            return this.raw.execute(args);
        }
        if (args.sqlClient.getSqlFormatter().isPretty()) {
            return this.prettyLog(args);
        }
        return this.simpleLog(args);
    }

    @Override
    public void openCursor(long cursorId, String sql, List<Object> variables, List<Integer> variablePositions, ExecutionPurpose purpose, @Nullable ExecutorContext ctx, JSqlClientImplementor sqlClient) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Open cursor(").append(cursorId).append(')').append(REQUEST).append('\n');
        ExecutorForLog.appendPrettyRequest(builder, sql, variables, variablePositions, purpose, ctx, sqlClient);
        this.logger.info(builder.toString());
    }

    @Override
    protected AbstractExecutorProxy recreate(Executor raw) {
        return new ExecutorForLog(raw, this.logger);
    }

    @Override
    protected Batch createBatch(Executor.BatchContext raw) {
        return new Batch(raw, this.logger);
    }

    private <R> R simpleLog(Executor.Args<R> args) {
        ExecutorContext ctx = args.ctx;
        String sql = args.sql;
        List<Object> variables = args.variables;
        if (ctx == null) {
            this.logger.info("jimmer> sql: " + sql + ", variables: " + variables + ", purpose: " + args.purpose);
        } else {
            Logger logger = LoggerFactory.getLogger((String)ctx.getPrimaryElement().getClassName());
            logger.info("jimmer> sql: " + sql + ", variables: " + variables + ", purpose: " + args.purpose);
            for (StackTraceElement element : ctx.getMatchedElements()) {
                logger.info("jimmer stacktrace-element)> {}", (Object)element);
            }
        }
        return this.raw.execute(args);
    }

    private <R> R prettyLog(Executor.Args<R> args) {
        R result = null;
        Throwable throwable = null;
        long millis = System.currentTimeMillis();
        try {
            result = this.raw.execute(args);
        }
        catch (Error | RuntimeException ex) {
            throwable = ex;
        }
        millis = System.currentTimeMillis() - millis;
        int affectedRowCount = -1;
        char ch = args.sql.charAt(0);
        if ((ch == 'i' || ch == 'u' || ch == 'd') && result instanceof Integer) {
            affectedRowCount = (Integer)result;
        }
        StringBuilder builder = new StringBuilder();
        if (args.closingCursorId == null) {
            builder.append("Execute SQL").append(REQUEST).append('\n');
            ExecutorForLog.appendPrettyRequest(builder, args.sql, args.variables, args.variablePositions, args.purpose, args.ctx, args.sqlClient);
        }
        ExecutorForLog.appendPrettyResponse(builder, affectedRowCount, throwable, millis);
        if (args.closingCursorId != null) {
            builder.append(RESPONSE).append("Close cursor(").append(args.closingCursorId).append(')');
        } else {
            Long currentCourseId = Cursors.currentCursorId();
            if (currentCourseId != null) {
                builder.append("CursorId: ").append(currentCourseId).append('\n');
            }
            builder.append(RESPONSE).append("Execute SQL");
        }
        this.logger.info(builder.toString());
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
        return result;
    }

    private static void appendPrettyRequest(StringBuilder builder, String sql, List<Object> variables, List<Integer> variablePositions, ExecutionPurpose purpose, ExecutorContext ctx, JSqlClientImplementor sqlClient) {
        if (ctx != null) {
            builder.append("--- Business related stack trace information ---\n");
            for (StackTraceElement element : ctx.getMatchedElements()) {
                builder.append(element).append('\n');
            }
        }
        builder.append("Purpose: ").append(purpose).append('\n');
        builder.append("SQL: ");
        if (variablePositions == null) {
            builder.append(sql);
        } else {
            sqlClient.getSqlFormatter().append(builder, sql, variables, variablePositions);
        }
        builder.append('\n');
    }

    private static void appendPrettyResponse(StringBuilder builder, int affectedRowCount, Throwable throwable, long millis) {
        if (affectedRowCount != -1) {
            builder.append("Affected row count: ").append(affectedRowCount).append('\n');
        }
        if (throwable == null) {
            builder.append("JDBC response status: success\n");
        } else {
            builder.append("JDBC response status: failed<").append(throwable.getClass().getName()).append(">\n");
        }
        builder.append("Time cost: ").append(millis).append("ms\n");
    }

    protected static class Batch
    extends AbstractExecutorProxy.Batch {
        private final Logger logger;
        private List<List<Object>> variableMatrix = new ArrayList<List<Object>>();

        Batch(Executor.BatchContext raw, Logger logger) {
            super(raw);
            this.logger = logger;
        }

        @Override
        public JSqlClientImplementor sqlClient() {
            return this.raw.sqlClient();
        }

        @Override
        public String sql() {
            return this.raw.sql();
        }

        @Override
        public ExecutionPurpose purpose() {
            return this.raw.purpose();
        }

        @Override
        public ExecutorContext ctx() {
            return this.raw.ctx();
        }

        @Override
        public void add(List<Object> variables) {
            this.raw.add(variables);
            this.variableMatrix.add(variables);
        }

        @Override
        public int[] execute(BiFunction<SQLException, ExceptionTranslator.Args, Exception> exceptionTranslator) {
            if (!this.logger.isInfoEnabled()) {
                return this.raw.execute(exceptionTranslator);
            }
            if (this.raw.sqlClient().getSqlFormatter().isPretty()) {
                return this.prettyLog(exceptionTranslator);
            }
            return this.simpleLog(exceptionTranslator);
        }

        @Override
        public Object[] generatedIds() {
            return this.raw.generatedIds();
        }

        @Override
        public void addExecutedListener(Runnable listener) {
            this.raw.addExecutedListener(listener);
        }

        @Override
        public void close() {
            this.raw.close();
        }

        private int[] simpleLog(BiFunction<SQLException, ExceptionTranslator.Args, Exception> exceptionTranslator) {
            ExecutorContext ectx = this.raw.ctx();
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            int size = this.variableMatrix.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append("batch-").append(i).append(": ");
                builder.append(this.variableMatrix.get(i));
            }
            builder.append("}");
            if (ectx == null) {
                this.logger.info("jimmer> sql: " + this.raw.sql() + ", variables: " + builder + ", purpose: " + this.raw.purpose());
            } else {
                Logger logger = LoggerFactory.getLogger((String)ectx.getPrimaryElement().getClassName());
                logger.info("jimmer> sql: " + this.raw.sql() + ", variables: " + builder + ", purpose: " + this.raw.purpose());
                for (StackTraceElement element : ectx.getMatchedElements()) {
                    logger.info("jimmer stacktrace-element)> {}", (Object)element);
                }
            }
            return this.raw.execute(exceptionTranslator);
        }

        private int[] prettyLog(BiFunction<SQLException, ExceptionTranslator.Args, Exception> exceptionTranslator) {
            int[] rowCounts = null;
            Throwable throwable = null;
            long millis = System.currentTimeMillis();
            try {
                rowCounts = this.raw.execute(exceptionTranslator);
            }
            catch (Error | RuntimeException ex) {
                throwable = ex;
            }
            millis = System.currentTimeMillis() - millis;
            int affectedRowCount = -1;
            char ch = this.raw.sql().charAt(0);
            if ((ch == 'i' || ch == 'u' || ch == 'd') && rowCounts != null) {
                affectedRowCount = 0;
                for (int rowCount : rowCounts) {
                    affectedRowCount += rowCount;
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Execute SQL").append(ExecutorForLog.REQUEST).append('\n');
            ExecutorForLog.appendPrettyRequest(builder, this.raw.sql(), Collections.emptyList(), null, this.raw.purpose(), this.raw.ctx(), this.raw.sqlClient());
            int size = this.variableMatrix.size();
            for (int i = 0; i < size; ++i) {
                builder.append("batch-").append(i).append(": ");
                builder.append(this.variableMatrix.get(i)).append('\n');
            }
            ExecutorForLog.appendPrettyResponse(builder, affectedRowCount, throwable, millis);
            this.logger.info(builder.toString());
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
            return rowCounts;
        }
    }
}

