/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class Converters {
    private static final ZoneOffset OFFSET = OffsetDateTime.now().getOffset();

    private Converters() {
    }

    public static Object tryConvert(Object value, Class<?> expectedType) {
        if (value == null || value.getClass() == expectedType) {
            return value;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            if (expectedType == Boolean.TYPE || expectedType == Boolean.class) {
                return num.intValue() != 0;
            }
            if (expectedType == Byte.TYPE || expectedType == Byte.class) {
                return num.byteValue();
            }
            if (expectedType == Short.TYPE || expectedType == Short.class) {
                return num.shortValue();
            }
            if (expectedType == Integer.TYPE || expectedType == Integer.class) {
                return num.intValue();
            }
            if (expectedType == Long.TYPE || expectedType == Long.class) {
                return num.longValue();
            }
            if (expectedType == Float.TYPE || expectedType == Float.class) {
                return Float.valueOf(num.floatValue());
            }
            if (expectedType == Double.TYPE || expectedType == Double.class) {
                return num.doubleValue();
            }
            if (expectedType == BigInteger.class) {
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (expectedType == BigDecimal.class) {
                if (value instanceof BigInteger) {
                    return new BigDecimal(value.toString());
                }
                if (value instanceof Double || value instanceof Float) {
                    return BigDecimal.valueOf(((Number)value).longValue());
                }
                return BigDecimal.valueOf(num.doubleValue());
            }
        }
        if (value instanceof Boolean && expectedType == Boolean.TYPE) {
            return value;
        }
        if (value instanceof String && (expectedType == Character.TYPE || expectedType == Character.class)) {
            return Character.valueOf(((String)value).charAt(0));
        }
        if (value instanceof ImmutableSpi && ((ImmutableSpi)value).__type() == ImmutableType.get(expectedType)) {
            return value;
        }
        if (value instanceof Instant) {
            return Converters.tryConvertInstant((Instant)value, expectedType);
        }
        if (value instanceof Date) {
            return Converters.tryConvertInstant(Instant.ofEpochMilli(((Date)value).getTime()), expectedType);
        }
        if (value instanceof Time) {
            return Converters.tryConvertInstant(Instant.ofEpochMilli(((Time)value).getTime()), expectedType);
        }
        if (value instanceof Timestamp) {
            return Converters.tryConvertInstant(((Timestamp)value).toInstant(), expectedType);
        }
        if (value instanceof java.util.Date) {
            return Converters.tryConvertInstant(((java.util.Date)value).toInstant(), expectedType);
        }
        if (value instanceof LocalDate) {
            return Converters.tryConvertInstant(((LocalDate)value).atTime(LocalTime.MIN).toInstant(OFFSET), expectedType);
        }
        if (value instanceof LocalTime) {
            return Converters.tryConvertInstant(((LocalTime)value).atDate(LocalDate.EPOCH).toInstant(OFFSET), expectedType);
        }
        if (value instanceof LocalDateTime) {
            return Converters.tryConvertInstant(((LocalDateTime)value).toInstant(OFFSET), expectedType);
        }
        if (value instanceof OffsetDateTime) {
            return Converters.tryConvertInstant(((OffsetDateTime)value).toInstant(), expectedType);
        }
        if (value instanceof ZonedDateTime) {
            return Converters.tryConvertInstant(((ZonedDateTime)value).toInstant(), expectedType);
        }
        return null;
    }

    private static Object tryConvertInstant(Instant instant, Class<?> expectedType) {
        if (expectedType == Instant.class) {
            return instant;
        }
        if (expectedType == java.util.Date.class) {
            return new java.util.Date(instant.toEpochMilli());
        }
        if (expectedType == Date.class) {
            return new Date(instant.toEpochMilli());
        }
        if (expectedType == Time.class) {
            return new Time(instant.toEpochMilli());
        }
        if (expectedType == Timestamp.class) {
            return new Timestamp(instant.toEpochMilli());
        }
        if (expectedType == LocalDate.class) {
            return instant.atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (expectedType == LocalTime.class) {
            return instant.atZone(ZoneId.systemDefault()).toLocalTime();
        }
        if (expectedType == LocalDateTime.class) {
            return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (expectedType == OffsetDateTime.class) {
            return instant.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (expectedType == ZonedDateTime.class) {
            return instant.atZone(ZoneId.systemDefault()).toOffsetDateTime().toZonedDateTime();
        }
        return null;
    }
}

