/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;
import javax.sql.DataSource;
import org.babyfish.jimmer.sql.transaction.AbstractTxConnectionManager;
import org.babyfish.jimmer.sql.transaction.TxConnectionManager;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ConnectionManager {
    public static final ConnectionManager EXTERNAL_ONLY = new ConnectionManager(){

        @Override
        public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
            if (con == null) {
                throw new IllegalArgumentException("The connection manager is not specified so \"ConnectionManager.EXTERNAL_ONLY\" which does not support no explicit JDBC connection execution is used as default. There are 2 choices: 1. Specify the connection when execute statement/command2. Specify the connection manager");
            }
            return block.apply(con);
        }
    };

    public <R> R execute(@Nullable Connection var1, Function<Connection, R> var2);

    default public <R> R execute(Function<Connection, R> block) {
        return this.execute(null, block);
    }

    public static ConnectionManager singleConnectionManager(final Connection connection) {
        if (connection == null) {
            return EXTERNAL_ONLY;
        }
        return new ConnectionManager(){

            @Override
            public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
                return block.apply(con == null ? connection : con);
            }
        };
    }

    public static TxConnectionManager simpleConnectionManager(final DataSource dataSource) {
        return new AbstractTxConnectionManager(){

            @Override
            protected Connection openConnection() throws SQLException {
                return dataSource.getConnection();
            }
        };
    }
}

