/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.runtime.PropScalarProviderFactory;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

class CombinedPropScalarProviderFactory
implements PropScalarProviderFactory {
    private static final PropScalarProviderFactory[] EMPTY_ARR = new PropScalarProviderFactory[0];
    final PropScalarProviderFactory[] arr;

    private CombinedPropScalarProviderFactory(PropScalarProviderFactory[] arr) {
        this.arr = arr;
    }

    static PropScalarProviderFactory combine(PropScalarProviderFactory a, PropScalarProviderFactory b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        LinkedHashSet<PropScalarProviderFactory> set = new LinkedHashSet<PropScalarProviderFactory>();
        if (a instanceof CombinedPropScalarProviderFactory) {
            set.addAll(Arrays.asList(((CombinedPropScalarProviderFactory)a).arr));
        } else {
            set.add(a);
        }
        if (b instanceof CombinedPropScalarProviderFactory) {
            set.addAll(Arrays.asList(((CombinedPropScalarProviderFactory)b).arr));
        } else {
            set.add(b);
        }
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() == 1) {
            return (PropScalarProviderFactory)set.iterator().next();
        }
        return new CombinedPropScalarProviderFactory(set.toArray(EMPTY_ARR));
    }

    @Override
    public ScalarProvider<?, ?> createScalarProvider(ImmutableProp prop) {
        ScalarProvider<?, ?> provider = null;
        PropScalarProviderFactory factory = null;
        for (PropScalarProviderFactory f : this.arr) {
            ScalarProvider<?, ?> p = f.createScalarProvider(prop);
            if (p == null) continue;
            if (provider == null) {
                provider = p;
                factory = f;
                continue;
            }
            if (provider.equals(p)) continue;
            throw new IllegalStateException("Conflict PropScalarProviderFactories \"" + factory + "\" and \"" + f + "\", they create different scalar provider for the property \"" + prop + "\"");
        }
        return provider;
    }
}

