/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExecutorProxy
implements Executor {
    protected final Executor raw;

    protected AbstractExecutorProxy(Executor raw) {
        this.raw = raw;
    }

    @Override
    public final Executor.BatchContext executeBatch(@NotNull Connection con, @NotNull String sql, @Nullable ImmutableProp generatedIdProp, @NotNull ExecutionPurpose purpose, @NotNull JSqlClientImplementor sqlClient) {
        return this.createBatch(this.raw.executeBatch(con, sql, generatedIdProp, purpose, sqlClient));
    }

    protected abstract AbstractExecutorProxy recreate(Executor var1);

    protected abstract Batch createBatch(Executor.BatchContext var1);

    protected static <P extends AbstractExecutorProxy> Applier applier(Class<P> proxyType, Predicate<P> reuse, Function<Executor, P> creator) {
        return new ApplierImpl(proxyType, reuse, creator);
    }

    public static <E extends Executor> E as(Executor executor, Class<E> proxyType) {
        if (proxyType.isAssignableFrom(executor.getClass())) {
            return (E)executor;
        }
        if (executor instanceof AbstractExecutorProxy) {
            return AbstractExecutorProxy.as(((AbstractExecutorProxy)executor).raw, proxyType);
        }
        return null;
    }

    protected static abstract class Batch
    implements Executor.BatchContext {
        protected final Executor.BatchContext raw;

        protected Batch(Executor.BatchContext raw) {
            this.raw = raw;
        }

        @Override
        public JSqlClientImplementor sqlClient() {
            return this.raw.sqlClient();
        }

        @Override
        public String sql() {
            return this.raw.sql();
        }

        @Override
        public ExecutionPurpose purpose() {
            return this.raw.purpose();
        }

        @Override
        public ExecutorContext ctx() {
            return this.raw.ctx();
        }

        @Override
        public void add(List<Object> variables) {
            this.raw.add(variables);
        }

        @Override
        public int[] execute(BiFunction<SQLException, ExceptionTranslator.Args, Exception> exceptionTranslator) {
            return this.raw.execute(exceptionTranslator);
        }

        @Override
        public Object[] generatedIds() {
            return this.raw.generatedIds();
        }

        @Override
        public void addExecutedListener(Runnable listener) {
            this.raw.addExecutedListener(listener);
        }

        @Override
        public void close() {
            this.raw.close();
        }
    }

    private static class ApplierImpl<P extends AbstractExecutorProxy>
    implements Applier {
        private final Class<P> proxyType;
        private final Predicate<P> reuse;
        private final Function<Executor, P> creator;

        private ApplierImpl(Class<P> proxyType, Predicate<P> reuse, Function<Executor, P> creator) {
            if (Modifier.isAbstract(proxyType.getModifiers())) {
                throw new IllegalArgumentException("Cannot create proxy applier for proxy type \"" + proxyType.getName() + "\", it should not be abstract type");
            }
            this.proxyType = proxyType;
            this.reuse = reuse;
            this.creator = creator;
        }

        @Override
        public Executor applyTo(Executor executor) {
            if (executor == null) {
                executor = DefaultExecutor.INSTANCE;
            }
            ArrayList<Executor> executors = new ArrayList<Executor>();
            ApplierImpl.expand(executor, executors);
            ListIterator itr = executors.listIterator(executors.size());
            Executor prev = null;
            boolean recreated = false;
            while (itr.hasPrevious()) {
                Executor cur = (Executor)itr.previous();
                if (recreated) {
                    Class<?> oldType = cur.getClass();
                    if (oldType != (cur = ((AbstractExecutorProxy)cur).recreate(prev)).getClass()) {
                        throw new IllegalStateException("Illegal method \"" + oldType.getName() + ".recreate\" is illegal, it must return an object whose type is \"" + oldType.getName() + "\"");
                    }
                } else if (this.proxyType.isAssignableFrom(cur.getClass())) {
                    if (this.reuse.test((AbstractExecutorProxy)cur)) {
                        return executor;
                    }
                    cur = (Executor)this.creator.apply(prev);
                    recreated = true;
                }
                prev = cur;
            }
            if (recreated) {
                return prev;
            }
            return (Executor)this.creator.apply(executor);
        }

        private static void expand(Executor executor, List<Executor> outputExecutors) {
            outputExecutors.add(executor);
            if (executor instanceof AbstractExecutorProxy) {
                AbstractExecutorProxy proxy = (AbstractExecutorProxy)executor;
                ApplierImpl.expand(proxy.raw, outputExecutors);
            }
        }
    }

    public static interface Applier {
        public Executor applyTo(Executor var1);
    }
}

